/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.liquorfile.scandata;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.misc.TradingDay;
import ordermate.integration.liquorfile.scandata.PersistentScandata;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_scandata_tradingday")
@AccessType(value="property")
public class ScandataTradingDayExport
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<TradingDay> tradingDay;
    private boolean exported;
    private String filename;
    private PersistentWriteableList<PersistentScandata> scandataEntries;

    public ScandataTradingDayExport() {
        this.tradingDay = this.createReference(ScandataTradingDayExport.Properties.TRADING_DAY);
        this.scandataEntries = (PersistentWriteableList)this.createList(ScandataTradingDayExport.Properties.SCANDATA_ENTRIES);
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    public void setExported(boolean value) {
        this.exported = value;
    }

    @Column(name="exported")
    public boolean isExported() {
        return this.exported;
    }

    public void setFilename(String value) {
        this.filename = value;
    }

    @Column(name="filename")
    public String getFilename() {
        return this.filename;
    }

    @Transient
    public List<PersistentScandata> getScandataEntries() {
        return this.scandataEntries.getUnmodifiable();
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    protected void setScandataEntries(List<PersistentScandata> scandataEntries) {
        this.scandataEntries = this.scandataEntries.clone();
        this.scandataEntries.set(scandataEntries);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TRADING_DAY;
        public PropertiedObject.Property EXPORTED;
        public PropertiedObject.Property FILENAME;
        public PropertiedObject.Property SCANDATA_ENTRIES;
    }
}

