/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty;

import au.com.ordermate.gui.GuiHandler;
import ordermate.OrderMate;
import ordermate.database.sales.Customer;
import ordermate.integration.loyalty.LoyaltyPointsInfoRecord;

public abstract class LoyaltyPointAuthority {
    protected Integer SHORT_TIMEOUT = 2000;
    protected Integer LONG_TIMEOUT = 10000;
    protected GuiHandler gui;

    public LoyaltyPointAuthority(GuiHandler handler) {
        this.gui = handler;
    }

    public GuiHandler getGuiHandler() {
        return this.gui;
    }

    protected boolean checkCustomer(Customer customer) {
        if (customer == null) {
            throw new IllegalArgumentException("Cannot check the value of a null customer!");
        }
        if (!customer.isPersistent()) {
            OrderMate.LOG.warn("Cannot check the value of a non-persistent Customer");
            return false;
        }
        return true;
    }

    protected void displayResult(String title, String text) {
        this.gui.displayOkDialog(title, text);
    }

    public abstract Integer updateNumberOfPoints(LoyaltyPointsInfoRecord var1);

    public abstract Long redeemPoints(LoyaltyPointsInfoRecord var1);

    public abstract Long accruePoints(LoyaltyPointsInfoRecord var1);

    public abstract boolean returnRedeemedPoints(LoyaltyPointsInfoRecord var1);

    public abstract boolean returnAccruedPoints(LoyaltyPointsInfoRecord var1);

    public abstract boolean resyncPoints(LoyaltyPointsInfoRecord var1);

    public abstract Long setResetNumberOfPoints(LoyaltyPointsInfoRecord var1);

    public abstract boolean fetchCustomerInfo(LoyaltyPointsInfoRecord var1);

    public abstract boolean updateCustomerInfo(LoyaltyPointsInfoRecord var1);
}

