/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import javax.swing.SwingUtilities;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;

public class LoyaltyResyncTask
extends AbstractTask {
    private final GuiHandler handler;
    private final Customer customer;

    public LoyaltyResyncTask(GuiHandler guiHandler, Customer theCustomer) {
        this.handler = guiHandler;
        this.customer = theCustomer;
    }

    public LoyaltyResyncTask(GuiHandler guiHandler, CustomerCard theCard) {
        this(guiHandler, PersistenceManager.getObject(Customer.class, Query.select(Customer.class).active(Customer.class).equals(Customer.Properties.CARD_ID, theCard.getCardId()).toString()));
    }

    @Override
    public String getName() {
        return this.customer != null ? "Resync Loyalty Points for " + this.customer.getName() + "..." : "Resync Loyalty Points for customer...";
    }

    @Override
    protected void performTask() throws Exception {
        if (SystemProperty.getInstance().isLoyaltyEnabled() && this.customer != null) {
            boolean success = LoyaltyPointAdministrator.getInstance().resynchPointsForCustomer(this.customer);
            if (success) {
                this.customer.getCustomerPoints().save();
            } else {
                this.displayErrorDialog();
            }
        }
    }

    @Override
    protected int getTotalSubTasks() {
        return 0;
    }

    private void displayErrorDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoyaltyResyncTask.this.handler.displayOkDialog("Customer points for " + LoyaltyResyncTask.this.customer.getName() + " could not be synchronised. The points shown may not be up-to-date, please try again later.", "Cannot Synchronise Customer Points!");
            }
        });
    }
}

