/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty.igt;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.database.sales.Customer;
import ordermate.integration.loyalty.igt.IGTCommand;
import ordermate.integration.loyalty.igt.RequestTypeMethod;

public abstract class IGTCommandHeader {
    protected static final String FIELD_SEPERATOR = "\t";
    private static final DateTimeUtils.ThreadLocalDateFormat dateFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yyyy"));
    private static final DateTimeUtils.ThreadLocalDateFormat timeFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("HH:mm:ss"));
    private int stationNumber;
    private int transactionNumber;
    private IGTCommand commandCode;
    private String accessKey;
    private int memberCardNumberMaxDigits = 1;
    private Date transactionDateTime;
    private String cardOrMemberNumber;
    private String attendant;
    private RequestTypeMethod requestType;

    public IGTCommandHeader(IGTCommand commandCode, Customer customer) {
        this.commandCode = commandCode;
        this.transactionDateTime = Calendar.getInstance().getTime();
        this.setMemberCardNumberMaxDigits(LoyaltyIntegrationConfig.getInstance().getMemberNumberLength());
        String reformattedCardOrMemberNumber = this.reformatCardId(customer.getCardID());
        this.setCardOrMemberNumber(reformattedCardOrMemberNumber);
        this.setRequestType(this.getRequestTypeMethod(reformattedCardOrMemberNumber));
        this.setAccessKey(LoyaltyIntegrationConfig.getInstance().getAccessKey() + (Object)((Object)commandCode));
    }

    public int getStationNumber() {
        return this.stationNumber;
    }

    void setStationNumber(int stationNumber) {
        this.stationNumber = stationNumber;
    }

    public int getTransactionNumber() {
        return this.transactionNumber;
    }

    void setTransactionNumber(int transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public IGTCommand getCommandCode() {
        return this.commandCode;
    }

    void setCommandCode(IGTCommand commandCode) {
        this.commandCode = commandCode;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public int getMemberCardNumberMaxDigits() {
        return this.memberCardNumberMaxDigits;
    }

    public void setMemberCardNumberMaxDigits(int memberCardNumberMaxDigits) {
        this.memberCardNumberMaxDigits = memberCardNumberMaxDigits;
    }

    public Date getTransactionDateTime() {
        return this.transactionDateTime;
    }

    void setTransactionDateTime(Date transactionDateTime) {
        this.transactionDateTime = transactionDateTime;
    }

    public String getCardOrMemberNumber() {
        return this.cardOrMemberNumber;
    }

    void setCardOrMemberNumber(String idNumber) {
        this.cardOrMemberNumber = idNumber;
    }

    public String getAttendant() {
        return this.attendant;
    }

    void setAttendant(String attendant) {
        this.attendant = attendant;
    }

    public RequestTypeMethod getRequestType() {
        return this.requestType;
    }

    void setRequestType(RequestTypeMethod requestType) {
        this.requestType = requestType;
    }

    public String buildMessageBlock() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getStationNumber()).append(FIELD_SEPERATOR).append(this.getTransactionNumber()).append(FIELD_SEPERATOR).append((Object)this.getCommandCode()).append(FIELD_SEPERATOR).append(this.getAccessKey()).append(FIELD_SEPERATOR).append(dateFormatter.getFormat().format(this.getTransactionDateTime())).append(FIELD_SEPERATOR).append(timeFormatter.getFormat().format(this.getTransactionDateTime())).append(FIELD_SEPERATOR);
        return builder.toString();
    }

    private String reformatCardId(String cardId) {
        if (cardId != null && cardId.length() > 0 && !StringUtils.isNumeric(cardId)) {
            String result = cardId;
            int sLen = cardId.length();
            if (!StringUtils.isNumeric(result.charAt(sLen - 1))) {
                result = StringUtils.removeChar(result, result.charAt(sLen - 1));
            }
            if (!StringUtils.isNumeric(result.charAt(0))) {
                result = StringUtils.removeChar(result, result.charAt(0));
            }
            if (result.length() <= this.getMemberCardNumberMaxDigits()) {
                while (result.length() > 0 && '0' == result.charAt(0)) {
                    result = result.substring(1);
                }
            }
            OrderMate.LOG.info("Reformatted Card ID from :" + cardId + " to " + result);
            if (result.length() > 0 && StringUtils.isNumeric(result)) {
                return result;
            }
        }
        return cardId;
    }

    RequestTypeMethod getRequestTypeMethod(String cardOrMemberNr) {
        if (cardOrMemberNr != null && cardOrMemberNr.length() <= this.getMemberCardNumberMaxDigits()) {
            return RequestTypeMethod.MEMBER_NUMBER;
        }
        return RequestTypeMethod.CARD_NUMBER;
    }
}

