/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty.igt;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.AbstractIntegrationExtID;
import ordermate.database.integration.IntegrationExtIDHelper;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.database.integration.TerminalIntegrationExtID;
import ordermate.database.integration.UserIntegrationExtID;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.users.User;
import ordermate.integration.loyalty.LoyaltyPointAuthority;
import ordermate.integration.loyalty.LoyaltyPointsInfoRecord;
import ordermate.integration.loyalty.LoyaltyTransactionNumberExecutable;
import ordermate.integration.loyalty.igt.IGTCommandHeader;
import ordermate.integration.loyalty.igt.IGTResponseHeader;
import ordermate.integration.loyalty.igt.PatronBalanceInquiryCommand;
import ordermate.integration.loyalty.igt.PatronBalanceInquiryResponse;
import ordermate.integration.loyalty.igt.PointsAccrualRequestCommand;
import ordermate.integration.loyalty.igt.PointsAccrualRequestResponse;
import ordermate.integration.loyalty.igt.RedeemRequestCommand;
import ordermate.integration.loyalty.igt.RedeemRequestResponse;

public class IGTLoyaltyPointAuthority
extends LoyaltyPointAuthority {
    private Map<Terminal, Integer> stationNumbersMap = new HashMap<Terminal, Integer>();
    private Map<User, String> attendantNumbersMap = new HashMap<User, String>();

    public IGTLoyaltyPointAuthority(GuiHandler handler) {
        super(handler);
    }

    @Override
    public Integer updateNumberOfPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        PatronBalanceInquiryResponse inquiryResponse;
        if (!this.valid(loyaltyInfo)) {
            return null;
        }
        PatronBalanceInquiryCommand inquiryCommand = new PatronBalanceInquiryCommand(loyaltyInfo.getCustomer());
        if (this.sendCommandToServer(inquiryCommand, inquiryResponse = new PatronBalanceInquiryResponse(), loyaltyInfo)) {
            return inquiryResponse.getPatronPoints();
        }
        return null;
    }

    @Override
    public boolean returnRedeemedPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (!this.valid(loyaltyInfo)) {
            return false;
        }
        loyaltyInfo.setNumPoints(-loyaltyInfo.getNumPoints());
        return this.redeemPoints(loyaltyInfo) != null;
    }

    @Override
    public boolean resyncPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendCommandToServer(IGTCommandHeader command, IGTResponseHeader response, LoyaltyPointsInfoRecord loyaltyInfo) {
        try {
            LoyaltyIntegrationConfig loyaltyConfig = LoyaltyIntegrationConfig.getInstance();
            try (Socket igtSocket = new Socket(loyaltyConfig.getServerIPAddress(), loyaltyConfig.getServerPort());){
                PrintWriter out = new PrintWriter(igtSocket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(igtSocket.getInputStream()));
                Integer transNum = PersistenceManager.getServerConnection().runSync(new LoyaltyTransactionNumberExecutable());
                command.setTransactionNumber(transNum);
                this.setStationNo(command, loyaltyInfo);
                this.setAttendantNo(command, loyaltyInfo);
                out.println(command.buildMessageBlock());
                response.parseResponseBlock(in.readLine());
            }
            if (!response.isSuccessfull() && response.isShowFailedReturnCode()) {
                OrderMate.LOG.error("IGT Loyalty System: Command unsuccessful - " + response.getReturnCode().toString());
                this.displayResult("The requested Loyalty Point Transaction cannot be approved", response.getReturnCode().toString());
            }
            return response.isSuccessfull();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("IGT Loyalty System: Error communicating with server - ", (Throwable)ex);
            return false;
        }
    }

    @Override
    public Long redeemPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (!this.valid(loyaltyInfo)) {
            return null;
        }
        RedeemRequestCommand redeemCommand = new RedeemRequestCommand(loyaltyInfo.getCustomer(), -loyaltyInfo.getNumPoints());
        redeemCommand.setReferenceCode(loyaltyInfo.getTransactionID());
        RedeemRequestResponse redeemResponse = new RedeemRequestResponse();
        if (this.sendCommandToServer(redeemCommand, redeemResponse, loyaltyInfo) && redeemResponse.isSuccessfull()) {
            return redeemResponse.getTransactionNumber();
        }
        return null;
    }

    @Override
    public Long accruePoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        PointsAccrualRequestResponse accrueResponse;
        if (!this.valid(loyaltyInfo)) {
            return null;
        }
        PointsAccrualRequestCommand accrueCommand = new PointsAccrualRequestCommand(loyaltyInfo.getCustomer(), loyaltyInfo.getNumPoints());
        if (this.sendCommandToServer(accrueCommand, accrueResponse = new PointsAccrualRequestResponse(), loyaltyInfo) && accrueResponse.isSuccessfull()) {
            return accrueResponse.getTransactionNumber();
        }
        return null;
    }

    @Override
    public Long setResetNumberOfPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        this.displayResult("Command Not Supported", "IGT System does not support setting the members number of points.");
        return null;
    }

    @Override
    public boolean returnAccruedPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        loyaltyInfo.setNumPoints(-loyaltyInfo.getNumPoints());
        return this.accruePoints(loyaltyInfo) != null;
    }

    private void setAttendantNo(IGTCommandHeader command, LoyaltyPointsInfoRecord loyaltyInfo) {
        LoyaltyIntegrationConfig loyaltyConfig = LoyaltyIntegrationConfig.getInstance();
        if (loyaltyInfo.getContext() != null && loyaltyInfo.getContext().getUser() != null) {
            User user = loyaltyInfo.getContext().getUser();
            if (this.attendantNumbersMap.containsKey(user)) {
                command.setAttendant(this.attendantNumbersMap.get(user));
            }
            UserIntegrationExtID userExtID = IntegrationExtIDHelper.getExtIDFor(UserIntegrationExtID.class, AbstractIntegrationExtID.IntegrationExtIDType.IGT, user);
            String attendant = "";
            attendant = userExtID != null && userExtID.getExternalID() != null ? userExtID.getExternalID().toString() : loyaltyConfig.getDefaultAttendant();
            command.setAttendant(attendant);
            this.attendantNumbersMap.put(user, attendant);
        } else {
            command.setAttendant(loyaltyConfig.getDefaultAttendant());
        }
    }

    private void setStationNo(IGTCommandHeader command, LoyaltyPointsInfoRecord loyaltyInfo) {
        LoyaltyIntegrationConfig loyaltyConfig = LoyaltyIntegrationConfig.getInstance();
        if (loyaltyInfo.getContext() != null && loyaltyInfo.getContext().getTerminal() != null) {
            Terminal term = loyaltyInfo.getContext().getTerminal();
            if (this.stationNumbersMap.containsKey(term)) {
                command.setStationNumber(this.stationNumbersMap.get(term));
            } else {
                TerminalIntegrationExtID termExtID = IntegrationExtIDHelper.getExtIDFor(TerminalIntegrationExtID.class, AbstractIntegrationExtID.IntegrationExtIDType.IGT, term);
                int stationNo = 0;
                if (termExtID != null && termExtID.getExternalID() != null) {
                    stationNo = termExtID.getExternalID().intValue();
                } else {
                    try {
                        stationNo = Integer.parseInt(loyaltyConfig.getDefaultTerminal());
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Error converting Default Terminal No: ", (Throwable)ex);
                    }
                }
                command.setStationNumber(stationNo);
                this.stationNumbersMap.put(term, stationNo);
            }
        } else {
            command.setStationNumber(Integer.parseInt(loyaltyConfig.getDefaultTerminal()));
        }
    }

    @Override
    public boolean fetchCustomerInfo(LoyaltyPointsInfoRecord loyaltyInfo) {
        PatronBalanceInquiryResponse inquiryResponse;
        if (!this.valid(loyaltyInfo)) {
            return false;
        }
        PatronBalanceInquiryCommand inquiryCommand = new PatronBalanceInquiryCommand(loyaltyInfo.getCustomer());
        if (this.sendCommandToServer(inquiryCommand, inquiryResponse = new PatronBalanceInquiryResponse(), loyaltyInfo)) {
            PatronBalanceInquiryResponse balanceResponse = inquiryResponse;
            Customer newCustomer = loyaltyInfo.getCustomer();
            this.parseAndAssignFirstAndLastName(newCustomer, balanceResponse.getPatronsName());
            newCustomer.setDOB(balanceResponse.getDateOfBirth());
            this.assignCustomerCategory(newCustomer, balanceResponse.getMembershipTeir());
            loyaltyInfo.setNumPoints(balanceResponse.getPatronPoints());
            return true;
        }
        return false;
    }

    private boolean valid(LoyaltyPointsInfoRecord loyaltyInfo) {
        return loyaltyInfo.getCustomer() != null && !StringUtils.isEmpty(loyaltyInfo.getCustomer().getCardID());
    }

    private void parseAndAssignFirstAndLastName(Customer customer, String fullName) {
        int posEndLastName = fullName.indexOf(",");
        if (posEndLastName > -1) {
            if (fullName.length() > posEndLastName + 2) {
                customer.setFirstName(fullName.substring(posEndLastName + 2));
            }
            if (posEndLastName > 1) {
                customer.setLastName(fullName.substring(0, posEndLastName));
            }
        }
    }

    private void assignCustomerCategory(Customer newCustomer, String membershipTier) {
        List<CustomerCategory> custCats = CustomerCategory.getAllCategories();
        for (CustomerCategory cat : custCats) {
            if (cat.getLabel().compareToIgnoreCase(membershipTier) != 0) continue;
            newCustomer.setCategory(cat);
            return;
        }
    }

    @Override
    public boolean updateCustomerInfo(LoyaltyPointsInfoRecord loyaltyInfo) {
        return this.fetchCustomerInfo(loyaltyInfo);
    }
}

