/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty.igt;

import au.com.ordermate.util.DateTimeUtils;
import java.text.ParseException;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.integration.loyalty.igt.IGTReturnCode;

public abstract class IGTResponseHeader {
    protected static final String FIELD_SEPERATOR = "\\t";
    protected static final int STATION_NO_INDEX = 0;
    protected static final int TRANSACTION_NO_INDEX = 1;
    protected static final int COMMAND_CODE_INDEX = 2;
    protected static final int RETURN_CODE_INDEX = 3;
    private static final int MEMBERSHIP_ID_INDEX = 4;
    private static final int PATRONS_NAME_INDEX = 5;
    private static final int PATRON_POINTS_INDEX = 6;
    private static final int MEMBERSHIP_CLASS = 7;
    private static final int MEMBERSHIP_TIER_INDEX = 8;
    private static final int DATE_OF_BIRTH_INDEX = 9;
    private String stationNumber;
    private int transactionNumber;
    private int commandCode;
    private IGTReturnCode returnCode;
    private String membershipID;
    private String patronsName;
    private int patronPoints;
    private String membershipClass;
    private String membershipTeir;
    private Date dateOfBirth;
    private boolean validResponse;
    private boolean showFailedReturnCode = true;

    IGTResponseHeader() {
    }

    public String getStationNumber() {
        return this.stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    public int getTransactionNumber() {
        return this.transactionNumber;
    }

    public void setTransactionNumber(int transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public int getCommandCode() {
        return this.commandCode;
    }

    public void setCommandCode(int commandCode) {
        this.commandCode = commandCode;
    }

    public IGTReturnCode getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(IGTReturnCode returnCode) {
        this.returnCode = returnCode;
    }

    public void setReturnCode(int code) {
        this.returnCode = IGTReturnCode.valueOf(code);
    }

    public String getMembershipID() {
        return this.membershipID;
    }

    void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    public String getPatronsName() {
        return this.patronsName;
    }

    void setPatronsName(String patronsName) {
        this.patronsName = patronsName;
    }

    public int getPatronPoints() {
        return this.patronPoints;
    }

    void setPatronPoints(int patronPoints) {
        this.patronPoints = patronPoints;
    }

    public String getMembershipClass() {
        return this.membershipClass;
    }

    void setMembershipClass(String value) {
        this.membershipClass = value;
    }

    public String getMembershipTeir() {
        return this.membershipTeir;
    }

    void setMembershipTeir(String membershipTeir) {
        this.membershipTeir = membershipTeir;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void parseResponseBlock(String responseStr) {
        if (responseStr == null) {
            this.validResponse = false;
            this.setReturnCode(IGTReturnCode.NO_RESPONSE);
            return;
        }
        String[] tokens = responseStr.split(FIELD_SEPERATOR, -1);
        if (tokens.length >= 4) {
            this.setStationNumber(tokens[0]);
            this.setTransactionNumber(Integer.parseInt(tokens[1]));
            this.setCommandCode(Integer.parseInt(tokens[2]));
            this.setReturnCode(Integer.valueOf(tokens[3]));
        }
        if (!this.getReturnCode().equals((Object)IGTReturnCode.SUCCESS) || tokens.length < 10) {
            this.validResponse = false;
            return;
        }
        this.setMembershipID(tokens[4]);
        this.setPatronsName(tokens[5]);
        this.setPatronPoints(Integer.parseInt(tokens[6]));
        this.setMembershipClass(tokens[7]);
        this.setMembershipTeir(tokens[8]);
        try {
            this.setDateOfBirth(DateTimeUtils.getDateOfBirthFormat().parse(tokens[9]));
        }
        catch (ParseException ex) {
            OrderMate.LOG.error("IGT Loyalty System: Error parsing Date Of Birth" + tokens[9]);
        }
        this.validResponse = true;
    }

    public boolean isSuccessfull() {
        return this.getReturnCode() != null && this.getReturnCode().equals((Object)IGTReturnCode.SUCCESS);
    }

    public boolean isValidResponse() {
        return this.validResponse;
    }

    public boolean isShowFailedReturnCode() {
        return this.showFailedReturnCode;
    }

    public void setShowFailedReturnCode(boolean showFailedReturnCode) {
        this.showFailedReturnCode = showFailedReturnCode;
    }
}

