/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty.igt;

public enum IGTReturnCode {
    SUCCESS(0, "Command Successfull"),
    CONVERSION_ERROR(1, "Conversion or format error"),
    INVALID_STATION(2, "Invalid station ID"),
    INVALID_COMMAND(3, "Invalid command code"),
    INVALID_ACCESS_KEY(4, "Invalid access key"),
    INVALID_MEMBER(5, "Invalid member card number"),
    DUPLICATE_REQUEST(6, "Duplicate request"),
    PATRON_ON_HOLD(7, "Patron is on hold"),
    VALIDATION_FAILURE(8, "API interface configuration or data validation failure"),
    POINTS_EXCEEDE(9, "Redemption points value exceeds available limit"),
    INSUFFICIENT_POINTS(10, "Insufficient points"),
    INVALID_TRANS_TYPE(11, "Invalid transaction type (Note: P=points is the only valid value)."),
    INVALID_POINTS_TOTAL(12, "Invalid points accrual amount"),
    INVALID_ATTENDANT(14, "Invalid attendant"),
    NOT_MEMBER(15, "Not a registered member of the club"),
    NO_RESPONSE(16, "No response recieved from the IGT Server");

    private int code;
    private String description;

    private IGTReturnCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return this.description;
    }

    public static IGTReturnCode valueOf(int code) {
        for (IGTReturnCode returnCode : IGTReturnCode.values()) {
            if (returnCode.getCode() != code) continue;
            return returnCode;
        }
        return INVALID_COMMAND;
    }
}

