/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty.igt;

public enum MemberStatusCode {
    UNKNOWN(0, "Unknown, no status has been set"),
    INTRODUCED(1, "Introduced, member has just been introduced to the club"),
    NOMINATED(2, "Nominated, member has been approved but is currently un-financial"),
    FINANCIAL(3, "Financial, approved and paid fees"),
    RENEWAL(4, "Renewal, in the renewal period await fee payment"),
    LAPSED(5, "Lapsed, fees not paid during the renewal period"),
    SUSPENDED(6, "Suspended, patron has been suspended by the club"),
    BANNED(7, "Banned, patron has been banned by the club (requires Re-Introduction)"),
    REJECTED(8, "Rejected, this patron's membership application was rejected"),
    REINTRODUCED(9, "Re-Introduced, this patron has re-applied for membership"),
    DECEASED(10, "Deceased, the patron has passed away"),
    PENDING(11, "Pending Approval, financial member waiting for board approval"),
    ARCHIVED(12, "Archived, after Banned, Lapsed or Deceased"),
    RESIGNED(13, "Resigned, member has resigned (requires Re-Introduction)");

    private int code;
    private String description;

    private MemberStatusCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("%d", this.code);
    }

    public String getDescription() {
        return this.description;
    }

    public static MemberStatusCode valueOf(int code) {
        for (MemberStatusCode statusCode : MemberStatusCode.values()) {
            if (statusCode.getCode() != code) continue;
            return statusCode;
        }
        return UNKNOWN;
    }
}

