/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty.trac;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.integration.loyalty.trac.TracAccountInfo;
import ordermate.integration.loyalty.trac.TracAdjustPoints;
import ordermate.integration.loyalty.trac.TracPlayerSearch;
import ordermate.integration.loyalty.trac.TracResponse;
import ordermate.integration.loyalty.trac.TracSessionToken;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import sun.misc.BASE64Encoder;

public class TracIntegrationProcessor {
    public static final String PLAYER_URI = "/xbis/player/player.srf";
    public static final String WEB_URI = "/xbis/wbuser/wbuser.srf";
    public static final String WBMGT_URI = "/xbis/wbmgt/wbmgt.srf";
    public static boolean isTestAuthRequired = false;

    public static WebResource.Builder createBuilder(String extraUri) {
        try {
            RestHelper rest = new RestHelper();
            Integer TIMEOUT = 5000;
            String uri = LoyaltyIntegrationConfig.getInstance().getServerIPAddress() + extraUri;
            WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
            if (isTestAuthRequired) {
                String authString = "automate:pvsloyaltyapiaccessforautomate";
                String authStringEnc = new BASE64Encoder().encode(authString.getBytes());
                return (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header("Authorization", (Object)("Basic " + authStringEnc)).header("dp-meta-option", (Object)"none")).type("application/xml")).accept(new String[]{"application/xml"});
            }
            return (WebResource.Builder)((WebResource.Builder)resource.header("dp-meta-option", (Object)"none").type("application/xml")).accept(new String[]{"application/xml"});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error creating builder for trac request", (Throwable)ex);
            return null;
        }
    }

    public static TracSessionToken getSessionToken(String user, String password) {
        try {
            boolean fine;
            OrderMate.LOG.info("Sending Session Token Request To Trac");
            WebResource.Builder builder = TracIntegrationProcessor.createBuilder(WEB_URI);
            String soapData = TracSessionToken.getSoapRequest(LoyaltyIntegrationConfig.getInstance().getServerIPAddress(), user, password);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)soapData);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                OrderMate.LOG.warn("Session Token Response Failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
                return null;
            }
            String responseXML = TracResponse.grabSOAPBody((String)response.getEntity(String.class), "loginuserResponse");
            OrderMate.LOG.info("Trac Session Token Request Successful");
            return TracSessionToken.getTokenFromXML(responseXML);
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            return null;
        }
    }

    public static TracAccountInfo getAccInfo(String sessionnumber, String plrlookupnumber) {
        try {
            boolean fine;
            OrderMate.LOG.info("Sending Account Info Request To Trac");
            WebResource.Builder builder = TracIntegrationProcessor.createBuilder(PLAYER_URI);
            String soapData = TracAccountInfo.getSoapRequest(LoyaltyIntegrationConfig.getInstance().getServerIPAddress(), sessionnumber, plrlookupnumber);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)soapData);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                OrderMate.LOG.warn("Session Account Info Response Failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
                return null;
            }
            String responseXML = TracResponse.grabSOAPBody((String)response.getEntity(String.class), "getacctinfoResponse");
            OrderMate.LOG.info("Trac Account Info Request Successful");
            return TracAccountInfo.getAccFromXML(responseXML);
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            return null;
        }
    }

    public static TracPlayerSearch getPlayerFromCard(String sessionnumber, String cardnumber) {
        try {
            boolean fine;
            OrderMate.LOG.info("Sending Player Info Request To Trac");
            WebResource.Builder builder = TracIntegrationProcessor.createBuilder(PLAYER_URI);
            String soapData = TracPlayerSearch.getSoapRequest(LoyaltyIntegrationConfig.getInstance().getServerIPAddress(), sessionnumber, cardnumber);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)soapData);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                OrderMate.LOG.warn("Session Player Info Response Failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
                return null;
            }
            String responseXML = TracResponse.grabSOAPBody((String)response.getEntity(String.class), "playersearchResponse");
            OrderMate.LOG.info("Trac Player Info Request Successful");
            return TracPlayerSearch.getAccFromXML(responseXML);
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            return null;
        }
    }

    public static TracAdjustPoints adjustPlayerPoints(String plrlookupnumber, String adjType, String adjPoints) {
        try {
            boolean fine;
            OrderMate.LOG.info("Sending Player Adjust Points Info: Player - " + plrlookupnumber + ", Points - " + adjPoints + ", Type: " + adjType);
            WebResource.Builder builder = TracIntegrationProcessor.createBuilder(WBMGT_URI);
            String soapData = TracAdjustPoints.getSoapRequest(LoyaltyIntegrationConfig.getInstance().getServerIPAddress(), LoyaltyIntegrationConfig.getInstance().getUsername(), plrlookupnumber, adjType, adjPoints);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)soapData);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                OrderMate.LOG.warn("Session Token Response Failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
                return null;
            }
            String responseXML = TracResponse.grabSOAPBody((String)response.getEntity(String.class), "adjustplayerbalancemanResponse");
            OrderMate.LOG.info("Trac Adjust Player Points Request Successful");
            return TracAdjustPoints.getResponseFromXML(responseXML);
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            return null;
        }
    }
}

