/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.loyalty.trac;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import ordermate.OrderMate;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.integration.loyalty.LoyaltyPointAuthority;
import ordermate.integration.loyalty.LoyaltyPointsInfoRecord;
import ordermate.integration.loyalty.trac.TracAccountInfo;
import ordermate.integration.loyalty.trac.TracAdjustPoints;
import ordermate.integration.loyalty.trac.TracIntegrationProcessor;
import ordermate.integration.loyalty.trac.TracSessionToken;

public class TracLoyaltyPointAuthority
extends LoyaltyPointAuthority {
    public TracLoyaltyPointAuthority(GuiHandler handler) {
        super(handler);
    }

    @Override
    public Integer updateNumberOfPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (!this.valid(loyaltyInfo)) {
            return null;
        }
        String sessionToken = this.getSessionToken();
        if (sessionToken == null) {
            return null;
        }
        TracAccountInfo info = TracIntegrationProcessor.getAccInfo(sessionToken, this.removeInvalidChars(loyaltyInfo.getCustomer().getCardID()));
        if (this.checkError("Error Updating Points: ", info.getResultcode(), info.getResulttext())) {
            return null;
        }
        double points = Double.parseDouble(this.removeInvalidChars(info.getPlrdetail().getPlrpointbalance().trim()));
        return (int)points;
    }

    private boolean checkError(String prelude, String resultCode, String resultText) {
        if (!StringUtils.isEmpty(resultCode)) {
            if ("US01".equals(resultCode) || "US04".equals(resultCode)) {
                resultText = resultText.concat(", Check Trac Configuration inside Officemate");
            }
            OrderMate.LOG.info("TRAC Integration: " + prelude + resultCode + "-" + resultText);
            this.displayResult(prelude + resultCode, resultText);
            return true;
        }
        return false;
    }

    @Override
    public Long redeemPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        OrderMate.LOG.info("Redeeming points for trac customer: " + loyaltyInfo.getCustomer().getCardID());
        if (!this.valid(loyaltyInfo)) {
            return null;
        }
        Integer pointsBeforeCall = this.updateNumberOfPoints(loyaltyInfo);
        if (pointsBeforeCall == null) {
            return null;
        }
        TracAdjustPoints adjResp = TracIntegrationProcessor.adjustPlayerPoints(this.removeInvalidChars(loyaltyInfo.getCustomer().getCardID()), "Debit", String.valueOf(Math.abs(loyaltyInfo.getNumPoints())));
        if (this.checkError("Error Reedeeming Loyalty Points: ", adjResp.getResultCode(), adjResp.getResultText())) {
            Integer pointsAfterCall = this.updateNumberOfPoints(loyaltyInfo);
            if (pointsAfterCall == null) {
                return null;
            }
            if (pointsAfterCall.equals(pointsBeforeCall)) {
                this.returnRedeemedPoints(loyaltyInfo);
            }
            return null;
        }
        return -1L;
    }

    @Override
    public Long accruePoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        OrderMate.LOG.info("Accruing points for trac customer: " + loyaltyInfo.getCustomer().getCardID());
        if (!this.valid(loyaltyInfo)) {
            return null;
        }
        TracAdjustPoints adjResp = TracIntegrationProcessor.adjustPlayerPoints(this.removeInvalidChars(loyaltyInfo.getCustomer().getCardID()), "Credit", String.valueOf(Math.abs(loyaltyInfo.getNumPoints())));
        if (this.checkError("Error Accruing Loyalty Points: ", adjResp.getResultCode(), adjResp.getResultText())) {
            return null;
        }
        return -1L;
    }

    @Override
    public boolean returnRedeemedPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (!this.valid(loyaltyInfo)) {
            OrderMate.LOG.info("Error returning redeemed points in Trac");
            return false;
        }
        return this.accruePoints(loyaltyInfo) != null;
    }

    @Override
    public boolean returnAccruedPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        OrderMate.LOG.info("Returning redeemed points for trac customer: " + loyaltyInfo.getCustomer().getCardID());
        if (!this.valid(loyaltyInfo)) {
            OrderMate.LOG.info("Error returning redeemed points in Trac");
            return false;
        }
        return this.redeemPoints(loyaltyInfo) != null;
    }

    private String removeInvalidChars(String str) {
        str = str.replaceAll("\\?", "");
        str = str.replaceAll(";", "");
        str = str.replaceAll(",", "");
        return str;
    }

    @Override
    public boolean resyncPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return true;
    }

    @Override
    public Long setResetNumberOfPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return null;
    }

    private boolean valid(LoyaltyPointsInfoRecord loyaltyInfo) {
        return loyaltyInfo.getCustomer() != null && !StringUtils.isEmpty(loyaltyInfo.getCustomer().getCardID());
    }

    @Override
    public boolean fetchCustomerInfo(LoyaltyPointsInfoRecord loyaltyInfo) {
        return false;
    }

    private String getSessionToken() {
        TracSessionToken token = TracIntegrationProcessor.getSessionToken(LoyaltyIntegrationConfig.getInstance().getUsername(), LoyaltyIntegrationConfig.getInstance().getPassword());
        if (token == null) {
            this.displayResult("Error communicating with trac", "Failed to retrieve session token, ");
            return null;
        }
        if (StringUtils.isEmpty(token.getSessionnumber())) {
            this.checkError("Error Fetching Customer: ", token.getResultcode(), token.getResulttext());
            return null;
        }
        return token.getSessionnumber();
    }

    @Override
    public boolean updateCustomerInfo(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (!this.valid(loyaltyInfo)) {
            return false;
        }
        String sessionToken = this.getSessionToken();
        if (sessionToken == null) {
            return false;
        }
        TracAccountInfo info = TracIntegrationProcessor.getAccInfo(sessionToken, this.removeInvalidChars(loyaltyInfo.getCustomer().getCardID()));
        if (this.checkError("Error Fetching Customer: ", info.getResultcode(), info.getResulttext())) {
            return false;
        }
        loyaltyInfo.getCustomer().setFirstName(info.getPlrdetail().getPlrfirstname());
        loyaltyInfo.getCustomer().setLastName(info.getPlrdetail().getPlrlastname());
        double points = Double.parseDouble(this.removeInvalidChars(info.getPlrdetail().getPlrpointbalance().trim()));
        loyaltyInfo.setNumPoints((int)points);
        return true;
    }
}

