/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.menuitem;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.inventory.InventoryBarcode;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.stock.StockItem;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.exportmapping.SimpleMapping;
import ordermate.integration.menuitem.MenuExportTemplate;
import ordermate.integration.menuitem.MenuStockItemSummary;

public class MenuExportMapping
extends SimpleMapping {
    public static final String[] VERSIONS = new String[]{"2.7.7+", "2.7.5", "2.7.4"};
    public MenuExportTemplate template;
    private int idx = 0;
    private final String version;
    private boolean v274;
    private boolean v275;
    private static final Double DOUBLE_0 = new Double(0.0);

    public MenuExportMapping(List newBusinessObjects) {
        this(newBusinessObjects, "Current");
    }

    public MenuExportMapping(List newBusinessObjects, String version) {
        super(newBusinessObjects, false);
        this.version = version;
        this.initMapping();
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    protected void initMapping() {
        super.initMapping();
        this.template = new MenuExportTemplate(this.version);
        this.v274 = this.version.equals(VERSIONS[2]);
        this.v275 = this.version.equals(VERSIONS[1]);
        this.addMapping(this.template.group, this.createAccessor("getGroup"));
        this.addMapping(this.template.name, this.createAccessor("getName"));
        this.addMapping(this.template.shortName, this.createAccessor("getShortName"));
        this.addMapping(this.template.category, this.createBusinessObjectAccessor("getCategory"));
        this.addMapping(this.template.printerGroup, this.createBusinessObjectAccessor("getPrinterGroup"));
        this.addMapping(this.template.foregroundColor, this.createAccessor("getForegroundColor"));
        this.addMapping(this.template.backgroundColor, this.createAccessor("getBackgroundColor"));
        this.addMapping(this.template.sequence, this.createBusinessObjectAccessor("getSequence"));
        this.addMapping(this.template.systemState, this.createBusinessObjectAccessor("getSystemState"));
        this.addMapping(this.template.price, this.createBusinessObjectAccessor("getPrice"));
        this.addMapping(this.template.size, this.createBusinessObjectAccessor("getSize"));
        this.addMapping(this.template.plusGroup, this.createAccessor("getPlusGroup"));
        this.addMapping(this.template.optionGroups, this.createAccessor("getOptionGroups"));
        this.addMapping(this.template.barcode, this.createAccessor("getBarcodes"));
        this.addMapping(this.template.purchaseCost, this.createBusinessObjectAccessor("getPurchaseCost"));
        this.addMapping(this.template.includeTax, this.createBusinessObjectAccessor("isTaxIncluded"));
        this.addMapping(this.template.supplier, this.createBusinessObjectAccessor("getStockSupplier"));
        this.addMapping(this.template.supplierCode, this.createBusinessObjectAccessor("getProductCode"));
        this.addMapping(this.template.stockOnHand, this.createBusinessObjectAccessor("getStockOnHand"));
        this.addMapping(this.template.purchaseQuantity, this.createAccessor("getPurchaseQuantity"));
        this.addMapping(this.template.displayMeasure, this.createAccessor("getDisplayMeasure"));
        this.addMapping(this.template.ingredientMeasure, this.createBusinessObjectAccessor("getIngredientMeasureUnit"));
        this.addMapping(this.template.outerName, this.createBusinessObjectAccessor("getOuterName"));
        this.addMapping(this.template.outerQuantity, this.createBusinessObjectAccessor("getOuterQuantity"));
        this.addMapping(this.template.minStock, this.createBusinessObjectAccessor("getSuggestedMin"));
        this.addMapping(this.template.maxStock, this.createBusinessObjectAccessor("getSuggestedMax"));
        if (!this.v274) {
            this.addMapping(this.template.minuses, this.createAccessor("getMinuses"));
        }
        if (!this.v274 && !this.v275) {
            this.addMapping(this.template.portion, this.createBusinessObjectAccessor("getPortion"));
            this.addMapping(this.template.taxCode, this.createBusinessObjectAccessor("getTaxCodes"));
            this.addMapping(this.template.menuId, this.createBusinessObjectAccessor("getMenuIdentifier"));
            this.addMapping(this.template.stockGroup, this.createAccessor("getStockGroup"));
            this.addMapping(this.template.stockName, this.createBusinessObjectAccessor("getLabel"));
            this.addMapping(this.template.ingredientQuantity, this.createAccessor("getUsageQuantity"));
            this.addMapping(this.template.stockId, this.createBusinessObjectAccessor("getStockIdentifier"));
            this.addMapping(this.template.stockBarcodes, this.createAccessor("getStockBarcodes"));
        }
    }

    protected String getRecordID(Object obj) {
        return Integer.toString(this.idx++);
    }

    @Override
    protected ExportTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected Class getBusinessObjectClass() {
        return MenuStockItemSummary.class;
    }

    public String getGroup(MenuStockItemSummary item) {
        if ((this.v274 || this.v275) && item.getItemSummary() == null && item.getStockItem() != null) {
            return item.getStockGroup().getLabelFull();
        }
        if (item.getInventoryGroup() == null) {
            return null;
        }
        return item.getInventoryGroup().getLabelFull();
    }

    public String getName(MenuStockItemSummary item) {
        if ((this.v274 || this.v275) && item.getItemSummary() == null && item.getStockItem() != null) {
            return item.getStockItem().getLabel();
        }
        return item.getName();
    }

    public String getShortName(MenuStockItemSummary item) {
        if ((this.v274 || this.v275) && item.getItemSummary() == null && item.getStockItem() != null) {
            return item.getStockItem().getShortName();
        }
        return item.getShortName();
    }

    public String getMinuses(MenuStockItemSummary item) {
        if (item.getMinuses() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = item.getMinuses().iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            InventoryRemove minus = (InventoryRemove)it.next();
            sb.append(minus.getLabel());
            if (minus.getModificationPrice() == null || minus.getModificationPrice().isZero()) continue;
            sb.append("(");
            sb.append(minus.getModificationPrice().toString());
            sb.append(")");
        }
        return sb.toString();
    }

    public String getOptionGroups(MenuStockItemSummary item) {
        if (item.getOptionGroups() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = item.getOptionGroups().iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            InventoryOptionGroup optionGroup = (InventoryOptionGroup)it.next();
            sb.append(optionGroup.getLabel());
        }
        return sb.toString();
    }

    public String getBarcodes(MenuStockItemSummary item) {
        if (item.getBarcodes() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = item.getBarcodes().iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            InventoryBarcode barcode = (InventoryBarcode)it.next();
            sb.append(barcode.getBarcode());
        }
        return sb.toString();
    }

    public String getPlusGroup(MenuStockItemSummary item) {
        if (item.getPlusGroup() == null) {
            return null;
        }
        return item.getPlusGroup().getLabel();
    }

    public Double getPurchaseQuantity(MenuStockItemSummary item) {
        if (item.getQuantityPerUnit() != null) {
            return new Double(item.getQuantityPerUnit().doubleValue());
        }
        return null;
    }

    public String getDisplayMeasure(MenuStockItemSummary item) {
        if (item.getQuantityPerUnit() != null) {
            StockItem stockItem = item.getStockItem();
            return MeasureUnitHelper.convertToOldSkoolMeasure(stockItem.getDisplayMeasureUnitContainer().getMeasureUnit(), stockItem.getDisplayMeasureUnitContainer().getMeasureContainer() == null ? "" : stockItem.getDisplayMeasureUnitContainer().getMeasureContainer().getLabel(), stockItem.getDisplayMeasureUnitContainer().getQuantityPerContainer()).getName();
        }
        return null;
    }

    public String getStockBarcodes(MenuStockItemSummary item) {
        if (item.getStockBarcodes() != null) {
            StringBuilder sb = new StringBuilder();
            Iterator it = item.getStockBarcodes().iterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                String barcode = (String)it.next();
                sb.append(barcode);
            }
            return sb.toString();
        }
        return null;
    }

    public Double getUsageQuantity(MenuStockItemSummary item) {
        if (item.getUsageQuantity() != null) {
            return new Double(item.getUsageQuantity().getRawValue());
        }
        return DOUBLE_0;
    }

    public String getStockGroup(MenuStockItemSummary item) {
        if (item.getStockGroup() == null) {
            return null;
        }
        return item.getStockGroup().getLabelFull();
    }

    public String getForegroundColor(MenuStockItemSummary item) {
        Color color = item.getForegroundColor();
        return this.colorValue(color);
    }

    public String getBackgroundColor(MenuStockItemSummary item) {
        Color color = item.getBackgroundColor();
        return this.colorValue(color);
    }

    private String colorValue(Color color) {
        if (color == null) {
            return null;
        }
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }
}

