/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.menuitem;

import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.List;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class MenuStockItemSummary {
    private ItemSummary itemSummary;
    private StockItem stockItem;
    private Quantity usageQuantity;
    private StockArea stockArea;

    public MenuStockItemSummary() {
    }

    public MenuStockItemSummary(ItemSummary itemSummary) {
        this.itemSummary = itemSummary;
    }

    public MenuStockItemSummary(StockItem stockItem, StockArea stockArea) {
        this.stockItem = stockItem;
        this.stockArea = stockArea;
    }

    public MenuStockItemSummary(ItemSummary itemSummary, StockItem stockItem, Quantity usageQuantity, StockArea stockArea) {
        this.itemSummary = itemSummary;
        this.stockItem = stockItem;
        this.usageQuantity = usageQuantity;
        this.stockArea = stockArea;
    }

    public ItemSummary getItemSummary() {
        return this.itemSummary == null ? null : this.itemSummary;
    }

    public void setItemSummary(ItemSummary itemSummary) {
        this.itemSummary = itemSummary;
    }

    public StockItem getStockItem() {
        return this.stockItem == null ? null : this.stockItem;
    }

    public void setStockItem(StockItem stockItem, Quantity usage, StockArea area) {
        if (this.itemSummary != null && usage == null) {
            throw new NullPointerException("The usage cannot be null when adding a stock item with the menu item " + this.itemSummary);
        }
        this.stockItem = stockItem;
        this.usageQuantity = usage;
        this.stockArea = area;
    }

    public Quantity getUsageQuantity() {
        return this.usageQuantity;
    }

    public Color getBackgroundColor() {
        return this.itemSummary == null ? null : this.itemSummary.getBackgroundColor();
    }

    public List getBarcodes() {
        return this.itemSummary == null ? null : this.itemSummary.getBarcodes();
    }

    public InventoryCategory getCategory() {
        return this.itemSummary == null ? null : this.itemSummary.getCategory();
    }

    public Color getForegroundColor() {
        return this.itemSummary == null ? null : this.itemSummary.getForegroundColor();
    }

    public InventoryGroup getInventoryGroup() {
        return this.itemSummary == null ? null : this.itemSummary.getInventoryGroup();
    }

    public InventoryItem getInventoryItem() {
        return this.itemSummary == null ? null : this.itemSummary.getInventoryItemObject();
    }

    public Integer getMenuIdentifier() {
        return this.itemSummary == null ? null : this.itemSummary.getMenuIdentifier();
    }

    public List getMinuses() {
        return this.itemSummary == null ? null : this.itemSummary.getMinuses();
    }

    public String getName() {
        return this.itemSummary == null ? null : this.itemSummary.getName();
    }

    public String getShortName() {
        return this.itemSummary == null ? null : this.itemSummary.getShortName();
    }

    public List getOptionGroups() {
        return this.itemSummary == null ? null : this.itemSummary.getOptionGroups();
    }

    public InventoryAddGroup getPlusGroup() {
        return this.itemSummary == null ? null : this.itemSummary.getPlusGroup();
    }

    public InventoryItemPortion getPortion() {
        return this.itemSummary == null ? null : this.itemSummary.getPortion();
    }

    public Price getPrice() {
        return this.itemSummary == null ? null : this.itemSummary.getPrice();
    }

    public PriceLevel getPriceLevel() {
        return this.itemSummary == null ? null : this.itemSummary.getPriceLevel();
    }

    public PrinterGroup getPrinterGroup() {
        return this.itemSummary == null ? null : this.itemSummary.getPrinterGroup();
    }

    public InventoryProfile getProfile() {
        return this.itemSummary == null ? null : this.itemSummary.getProfile();
    }

    public Integer getSequence() {
        return this.itemSummary == null ? null : this.itemSummary.getSequence();
    }

    public InventoryItemSize getSize() {
        return this.itemSummary == null ? null : this.itemSummary.getSize();
    }

    public String getSystemState() {
        return this.itemSummary == null ? null : this.itemSummary.getSystemState();
    }

    public String getTaxCodes() {
        return this.itemSummary == null ? null : TaxCode.convertToString(this.itemSummary.getTaxCodes());
    }

    public Boolean isTaxIncluded() {
        return this.stockItem == null ? null : Boolean.valueOf(this.stockItem.isTaxIncluded());
    }

    public Price getPurchaseCost() {
        return this.stockItem == null ? null : this.stockItem.getCurrentReplacementCost();
    }

    public MeasureUnitI getDisplayMeasureUnit() {
        return this.stockItem == null ? null : MeasureUnitHelper.convertToOldSkoolMeasure(this.stockItem.getDisplayMeasureUnitContainer().getMeasureUnit(), this.stockItem.getDisplayMeasureUnitContainer().getMeasureContainer().getLabel(), this.stockItem.getDisplayMeasureUnitContainer().getQuantityPerContainer());
    }

    public MeasureUnitI getIngredientMeasureUnit() {
        return this.stockItem == null ? null : this.stockItem.getIngredientMeasureUnit();
    }

    public String getLabel() {
        return this.stockItem == null ? null : this.stockItem.getLabel();
    }

    public String getOuterDisplayName() {
        return this.stockItem == null ? null : this.stockItem.getOuterName();
    }

    public String getOuterName() {
        return this.stockItem == null ? null : this.stockItem.getOuterName();
    }

    public Double getOuterQuantity() {
        return this.stockItem == null ? null : new Double(this.stockItem.getOuterQuantity());
    }

    public String getProductCode() {
        return this.stockItem == null ? null : this.stockItem.getProductCode(this.getDefaultSupplier());
    }

    public StockGroup getStockGroup() {
        return this.stockItem == null ? null : (this.stockItem == null ? null : this.stockItem.getStockGroup());
    }

    public StockSupplier getStockSupplier() {
        return this.getDefaultSupplier();
    }

    public Double getStockOnHand() {
        if (this.stockItem == null || this.stockItem.getTotalStockOnHand() == null) {
            return null;
        }
        return new Double(this.stockItem.getTotalStockOnHand().doubleValue());
    }

    public List getStockBarcodes() {
        return this.stockItem == null ? null : this.stockItem.getBarcodes();
    }

    public Quantity getQuantityPerUnit() {
        return this.stockItem == null ? null : this.stockItem.getPurchaseQty();
    }

    public Double getSuggestedMin() {
        if (this.stockItem == null || this.stockItem.getSuggestedMin(this.stockArea) == null || this.stockItem.getSuggestedMin(this.stockArea).doubleValue() == 0.0) {
            return null;
        }
        return new Double(this.stockItem.getSuggestedMin(this.stockArea).doubleValue());
    }

    public Double getSuggestedMax() {
        if (this.stockItem == null || this.stockItem.getSuggestedMax(this.stockArea) == null || this.stockItem.getSuggestedMax(this.stockArea).doubleValue() == 0.0) {
            return null;
        }
        return new Double(this.stockItem.getSuggestedMax(this.stockArea).doubleValue());
    }

    public Integer getStockIdentifier() {
        return this.stockItem == null ? null : this.stockItem.getStockIdentifier();
    }

    public String toString() {
        if (this.stockItem == null) {
            return this.itemSummary.toString();
        }
        return this.itemSummary + " with " + this.usageQuantity + " " + this.stockItem;
    }

    public void generateIdentifier() {
        if (this.stockItem != null && this.getStockIdentifier() == null) {
            this.stockItem.setStockIdentifier((int)(this.stockItem.getID() % Integer.MAX_VALUE));
            this.stockItem.save();
        }
        if (this.itemSummary != null && this.getMenuIdentifier() == null) {
            InventoryItemUnit unit = this.itemSummary.getInventoryItemUnitObject();
            this.itemSummary.setMenuIdentifier(unit.getID().intValue());
            this.itemSummary.save();
        }
    }

    private StockSupplier getDefaultSupplier() {
        StockSupplier supplier = null;
        if (this.stockItem != null && this.stockItem.getSuppliers().size() > 0) {
            supplier = this.stockItem.getSuppliers().get(0);
        }
        return supplier;
    }
}

