/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.menuitem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.inventory.ItemSummaryQueries;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.menuitem.MenuStockItemSummary;

public class MenuStockItemSummaryManager {
    private final InventoryProfile profile;
    private final PriceLevel priceLevel;
    private final StockArea stockArea;
    private final InventoryGroup inventoryGroup;
    private final List resultList = new ArrayList(500);

    public MenuStockItemSummaryManager(InventoryProfile profile, PriceLevel priceLevel, StockArea stockArea, InventoryGroup inventoryGroup) {
        if (profile == null) {
            throw new NullPointerException("Cannot extract the item with a null profile");
        }
        if (priceLevel == null) {
            throw new NullPointerException("Cannot extract the item with a null price level");
        }
        if (stockArea == null) {
            throw new NullPointerException("Cannot extract the stock item with a null stock area");
        }
        this.profile = profile;
        this.priceLevel = priceLevel;
        this.stockArea = stockArea;
        this.inventoryGroup = inventoryGroup;
        this.refresh();
    }

    public List getResultList() {
        return Collections.unmodifiableList(this.resultList);
    }

    public void refresh() {
        this.resultList.clear();
        ItemSummaryQueries queries = new ItemSummaryQueries();
        List menuList = this.inventoryGroup != null ? queries.getSummaries(this.profile, this.priceLevel, this.inventoryGroup) : queries.getSummaries(this.profile, this.priceLevel);
        HashSet<StockItem> stockSet = new HashSet<StockItem>(250);
        for (ItemSummary item : menuList) {
            List usages = item.getStockUsage();
            Iterator usageIt = usages.iterator();
            do {
                MenuStockItemSummary instance = new MenuStockItemSummary(item);
                if (usageIt.hasNext()) {
                    StockInventoryUsageLink usage = (StockInventoryUsageLink)usageIt.next();
                    instance.setStockItem(usage.getStockItem(), usage.getQuantity(), this.stockArea);
                    stockSet.add(usage.getStockItem());
                }
                this.resultList.add(instance);
            } while (usageIt.hasNext());
        }
        List<StockItem> unlinked = null;
        if (this.inventoryGroup != null) {
            StockGroup stockGroup = StockGroup.getStockGroupForName(this.inventoryGroup.getLabel());
            if (stockGroup != null) {
                unlinked = StockItemQueries.getStockItemsForGroup(stockGroup);
            }
        } else {
            unlinked = StockItemQueries.getStockItemsStockableIn(this.stockArea);
        }
        if (unlinked != null && unlinked.size() > 0) {
            unlinked.removeAll(stockSet);
            for (StockItem item : unlinked) {
                MenuStockItemSummary instance = new MenuStockItemSummary(item, this.stockArea);
                this.resultList.add(instance);
            }
        }
    }
}

