/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.newsletter;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.users.User;
import ordermate.integration.newsletter.NewsletterHelper;
import ordermate.integration.webservice.RestHelper;

public class NewsletterSignupAgent {
    private Long memberId;
    private GuiHandler handler;
    private String firstName;
    private String lastName;
    private String email;
    private String position;
    private String site;
    private String mobile;
    private BusinessInfo info;

    public NewsletterSignupAgent(GuiHandler guiHandler) {
        this.handler = guiHandler;
    }

    public void setDetails(User user) {
        this.memberId = user.getID();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.email = user.getEmail();
        this.mobile = user.getMobile();
        this.position = user.getPermissionGroup().getDisplayLabel();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPosition() {
        return this.position;
    }

    public void setFirstName(String value) {
        this.firstName = value;
    }

    public void setLastName(String value) {
        this.lastName = value;
    }

    public void setPosition(String value) {
        this.position = value;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String value) {
        this.mobile = value;
    }

    public boolean doSignUp() {
        this.info = BusinessInfo.getInstance();
        if (this.info == null || StringUtils.isEmpty(this.info.getName())) {
            this.handler.displayOkDialog("Cannot Sign Up", "There is no business information with which to signup.");
            return false;
        }
        this.site = this.info.getName();
        this.firstName = this.firstName == null ? "" : this.firstName.trim();
        this.lastName = this.lastName == null ? "" : this.lastName.trim();
        this.email = this.email == null ? "" : this.email.trim();
        String string = this.position = this.position == null ? "" : this.position.trim();
        if (StringUtils.isEmpty(this.firstName) || StringUtils.isEmpty(this.email) || StringUtils.isEmpty(this.position) || StringUtils.isEmpty(this.lastName)) {
            this.handler.displayOkDialog("Cannot Sign Up", "The Name, email and positions may not be empty");
            return false;
        }
        return this.performSignup();
    }

    private boolean performSignup() {
        RestHelper helper = new RestHelper();
        WebResource resource = helper.getResource(NewsletterHelper.getNewContactString());
        OrderMate.LOG.info("Hitting MyGuestlist on :" + resource);
        boolean fine = false;
        if (this.memberId == null) {
            this.memberId = Long.valueOf("1");
        }
        Map<String, String> form = NewsletterHelper.getDefaultParams(this.memberId);
        form.put("PatronEmail", this.email);
        form.put("PatronName", this.firstName);
        form.put("PatronSurname", this.lastName);
        form.put("SiteName", this.site);
        form.put("JobDescription", this.position);
        if (this.mobile != null && !this.mobile.trim().isEmpty()) {
            form.put("PatronMobile", this.mobile.trim());
        }
        ArrayList<Map<String, String>> contactWrapper = new ArrayList<Map<String, String>>();
        contactWrapper.add(form);
        String json = NewsletterHelper.convertToJson(contactWrapper);
        try {
            WebResource.Builder builder = resource.accept(new String[]{"text/plain"});
            String result = (String)builder.post(String.class, (Object)json);
            fine = this.interpretResult(result);
            this.handler.displayOkDialog("Sign up Successful", "<html>Thank you!<br><br>" + this.email + " has been signed up to the OrderMate News Letter.</html>");
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.warn("Cannot contact MyGuestlist to sign up user", (Throwable)ex);
            this.handler.displayOkDialog("Could not sign up", "<html>There is a problem signing up to the Newsletter.<br>Please check your internet connection.</html>");
            fine = false;
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Badness connecting to MyGuestlist:", (Throwable)ex);
            this.handler.displayOkDialog("Could not sign up", "<html>There is a problem signing up to the Newsletter.<br>Please contact Ordermate if this persists.</html>");
            fine = false;
        }
        return fine;
    }

    boolean interpretResult(String result) {
        Object[] values;
        OrderMate.LOG.info("Got result from myGuestlist:" + result);
        Map response = NewsletterHelper.convertFromJson(result);
        return response.containsKey("success") && (values = (Object[])response.get("success")) != null && values.length > 0;
    }
}

