/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.nudgeback;

import au.com.ordermate.message.Email;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.InternetAddress;
import ordermate.OrderMate;

public class EmailBuilder {
    private static final String NO_REPLY_SENDER_EMAIL = "noreply@ordermate.com.au";
    private static final String NO_REPLY_SENDER_NAME = "No Reply";
    private String subject;
    private String body;
    private boolean noReply;
    private final List<Pair<String, String>> recipients;
    private final List<File> attachments;

    public EmailBuilder(String subject, String body, boolean noReply, String recipients) {
        this.subject = subject;
        this.body = body;
        this.noReply = noReply;
        this.recipients = this.convertToRecipients(recipients);
        this.attachments = new ArrayList<File>();
    }

    public Email build() {
        Email email = new Email();
        email.setSubject(this.subject);
        email.setText(this.body);
        if (this.noReply) {
            email.addSender(NO_REPLY_SENDER_EMAIL, NO_REPLY_SENDER_NAME);
        }
        for (Pair<String, String> recipient : this.recipients) {
            try {
                if (!StringUtils.isEmpty((String)recipient.key) || recipient.value != null) {
                    email.addToRecipient((String)recipient.key, (String)recipient.value);
                    continue;
                }
                email.addToRecipient(new InternetAddress((String)recipient.key));
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Could not add sender to email", (Throwable)ex);
            }
        }
        for (File attachment : this.attachments) {
            email.addAttachment(attachment);
        }
        return email;
    }

    public EmailBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public EmailBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public EmailBuilder isNoReply(boolean noReply) {
        this.noReply = noReply;
        return this;
    }

    public EmailBuilder addRecipient(String recipient) {
        this.recipients.add(this.convertToRecipient(recipient));
        return this;
    }

    public EmailBuilder addRecipients(String recipients) {
        this.recipients.addAll(this.convertToRecipients(recipients));
        return this;
    }

    public EmailBuilder addAttachment(File file) {
        this.attachments.add(file);
        return this;
    }

    public EmailBuilder addAttachments(List<File> files) {
        this.attachments.addAll(files);
        return this;
    }

    private Pair<String, String> convertToRecipient(String mailTo) {
        return StringUtils.splitToPair(mailTo, ":");
    }

    private List<Pair<String, String>> convertToRecipients(String mailTo) {
        return StringUtils.splitToPairs(mailTo, ":", ";");
    }
}

