/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.oauth;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.schedule.Schedule;
import ordermate.integration.finance.xero.XeroWebserviceHelper;
import ordermate.integration.oauth.OAuth2ClientHandler;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import ordermate.internationalization.Internationalization;
import ordermate.microserver.MicroServer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import sun.misc.BASE64Decoder;

public class OAuth2Client {
    private final WebserviceIntegrationConfig webConfig;
    private final OAuth2ClientHandler handler;
    private final GuiHandler gui;
    public final Signal<WebserviceIntegrationConfig, Boolean, ?, ?, ?> statusSignal = Signals.createSignal(WebserviceIntegrationConfig.class, "webConfig", Boolean.class, "status");
    private MicroServer server;
    private final String redirect = "http://localhost:";
    private final int port = 8228;
    private final String contextPath = "/oauth/auth";
    private static final String AUTH_GRANT = "authorization_code";
    private static final String REFRESH_GRANT = "refresh_token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String TOKEN = "token";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRES_IN = "expires_in";
    private static final String CODE = "code";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String XERO_AUTH_URL = "https://api.xero.com/api.xro/2.0/";
    private static final Integer TIMEOUT = 5000;
    private boolean useBrowser = true;

    public OAuth2Client(WebserviceIntegrationConfig webConfig, OAuth2ClientHandler handler, GuiHandler gui) {
        if (handler == null || webConfig == null || gui == null) {
            throw new IllegalArgumentException("Web Config and OAuth2ClientHandler and Gui cannot be null");
        }
        this.webConfig = webConfig;
        this.handler = handler;
        this.gui = gui;
    }

    void setUseBrowser(boolean value) {
        this.useBrowser = value;
    }

    public WebResource createAPIResource(String endpoint) {
        if (this.needsRefresh() && !this.initiateRefresh()) {
            return null;
        }
        RestHelper rs = new RestHelper();
        WebResource resource = this.createWebResource(rs, endpoint, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        resource = rs.addBearerAuth(resource, this.webConfig.getAccessToken());
        resource = this.handler.modifyResource(resource, this.webConfig);
        return resource;
    }

    private String getAuthenticationEventId() {
        if (this.webConfig == null) {
            OrderMate.LOG.info("WebConfig is null ");
            return null;
        }
        String accessToken = this.webConfig.getAccessToken();
        String[] parts = accessToken.split("\\.");
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            String decodedHeader = new String(decoder.decodeBuffer(parts[0]));
            OrderMate.LOG.info("OAuthClient 2.0 :: header ::  " + decodedHeader);
            String decodeBody = new String(decoder.decodeBuffer(parts[1]));
            JSONObject bodyJSON = new JSONObject(decodeBody);
            OrderMate.LOG.info("OAuthClient 2.0 :: body ::  " + decodeBody);
            String authEventId = bodyJSON.get("authentication_event_id").toString();
            OrderMate.LOG.info("OAuthClient :: Authentication Event Id : " + authEventId);
            return authEventId;
        }
        catch (JSONException jsonException) {
            OrderMate.LOG.error((Object)jsonException);
        }
        catch (IOException e) {
            OrderMate.LOG.error((Object)e);
        }
        return null;
    }

    public WebResource createWebResource(RestHelper rs, String url, X509TrustManager trustManager, Integer connectionTimeoutArg, Integer readTimeoutArg, String httpsProtocol) {
        int connectionTimeout = this.webConfig.getConnectionTimeout() == null ? connectionTimeoutArg : this.webConfig.getConnectionTimeout();
        int readTimeout = this.webConfig.getReadTimeout() == null ? readTimeoutArg : this.webConfig.getReadTimeout();
        return rs.getSSLWebResource(url, trustManager, connectionTimeout, readTimeout, httpsProtocol);
    }

    public boolean validate() {
        boolean allOk;
        block4: {
            allOk = true;
            if (this.needsRefresh()) {
                allOk = this.initiateRefresh();
            }
            if (allOk) {
                XeroWebserviceHelper helper = new XeroWebserviceHelper(this.gui);
                try {
                    allOk = helper.testConnection();
                }
                catch (Exception ex) {
                    allOk = false;
                    OrderMate.LOG.warn("Couldn't validate connection to Xero", (Throwable)ex);
                    if (StringUtils.isEmpty(ex.getMessage()) || !ex.getMessage().contains("403")) break block4;
                    OrderMate.LOG.info("Xero has been disconnected at Xero side, clearing the tokens. Reconnect required.");
                    this.webConfig.setAccessToken(null);
                    this.webConfig.setRefreshToken(null);
                    this.webConfig.setExpires(null);
                    this.webConfig.save();
                    this.gui.displayOkDialog("Xero Disconnected", "Xero has been disconnected. Please reconnect.");
                }
            }
        }
        return allOk;
    }

    public boolean initiateRefresh() {
        if (this.webConfig.getClientId() == null || this.webConfig.getClientSecret() == null) {
            this.gui.displayOkDialog("No Client ID", "Cannot proceed without clientId and clientSecret set");
            return false;
        }
        if (this.webConfig.getRefreshToken() == null) {
            this.gui.displayOkDialog("No Refresh Token", "Refresh token is not present, please provide access first." + System.lineSeparator() + "Please reconnect you Integration");
            return false;
        }
        OrderMate.LOG.info("Initiating refresh on " + this.webConfig.getDescription());
        RestHelper rs = new RestHelper();
        WebResource resource = this.createWebResource(rs, this.handler.getRefreshEndpoint(), new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        resource = rs.addBasicAuth(resource, this.webConfig.getClientId(), this.webConfig.getClientSecret());
        Form form = new Form();
        form.add(GRANT_TYPE, "refresh_token");
        form.add("refresh_token", this.webConfig.getRefreshToken());
        this.getAuthenticationEventId();
        ClientResponse response = (ClientResponse)resource.type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)form);
        if (response.getStatus() / 100 == 2) {
            return this.processRefreshResponse(response);
        }
        OrderMate.LOG.warn("Problem handling the OAuth2 refresh response:\r\n" + (String)response.getEntity(String.class));
        this.gui.displayOkDialog("Refresh Failed", "Could not handle the refresh");
        return false;
    }

    public boolean initiateDisconnect() {
        if (this.webConfig.getAccessToken() == null || this.webConfig.getClientSecret() == null) {
            this.gui.displayOkDialog("Already Disconnected", "No Access Token, this is already disconnected");
            return false;
        }
        OrderMate.LOG.info("Disconnecting Xero");
        RestHelper rs = new RestHelper();
        WebResource resource = this.createWebResource(rs, this.handler.getDisconnectEndpoint(), new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        resource = rs.addBasicAuth(resource, this.webConfig.getClientId(), this.webConfig.getClientSecret());
        Form form = new Form();
        form.add(TOKEN, this.webConfig.getRefreshToken());
        ClientResponse response = (ClientResponse)resource.type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)form);
        if (response.getStatus() / 100 == 2) {
            this.webConfig.setAccessToken(null);
            this.webConfig.setRefreshToken(null);
            this.webConfig.setExpires(null);
            this.webConfig.save();
            OrderMate.LOG.info("Xero has been disconnected");
            if (XERO_AUTH_URL.equals(this.webConfig.getUrl())) {
                Schedule schedule = OAuth2Client.getXeroTokenRefreshSchedule();
                schedule.setRecurrence("");
                schedule.setSystemState(SystemState.DELETED_STATE);
                schedule.save();
                OrderMate.LOG.info("Xero Token Refresh Schedule Disabled.");
            }
            this.gui.displayOkDialog("Xero Disconnected", "You have now revoked the token for Xero.");
            this.statusSignal.emit(this.webConfig, Boolean.TRUE);
            return true;
        }
        OrderMate.LOG.warn("Problem handling the OAuth2 disconnect response:" + System.lineSeparator() + (String)response.getEntity(String.class));
        this.gui.displayOkDialog("Disconnect Failed", "Could not disconnect from Xero");
        this.statusSignal.emit(this.webConfig, Boolean.FALSE);
        return false;
    }

    public void initiateAuthorization() {
        if (this.webConfig.getClientId() == null || this.webConfig.getClientSecret() == null) {
            this.gui.displayOkDialog("No Client ID", "Cannot proceed without clientId and clientSecret set");
            return;
        }
        String endpoint = this.handler.getAuthEndpoint(this.getRedirectPath(), this.webConfig);
        OrderMate.LOG.info("Sending to " + endpoint);
        try {
            if (this.useBrowser) {
                Desktop.getDesktop().browse(new URL(endpoint).toURI());
            }
            if (this.server == null) {
                this.server = new MicroServer(8228, "/oauth/auth", new OAuth2ReceiverServlet());
            }
            this.server.tryStop();
            this.server.prime();
            this.server.tryStart();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot initiate browser for Authorisation", (Throwable)ex);
            this.stopServer();
        }
        catch (URISyntaxException ex) {
            OrderMate.LOG.error("Maformed URL for Authorisation: " + endpoint, (Throwable)ex);
            this.stopServer();
        }
    }

    public static Schedule getXeroTokenRefreshSchedule() {
        Schedule schedule = PersistenceManager.getObject(Schedule.class, Query.select(Schedule.class).equals(Schedule.Properties.LABEL, "Xero Token Refresh").toString());
        if (schedule == null) {
            schedule = new Schedule();
            schedule.setTask("Xero Token Refresh");
            schedule.setLabel("Xero Token Refresh");
            schedule.setRecurrence("");
            try {
                schedule.save();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("PushNonRoomSalesTask cannnot be saved", (Throwable)ex);
            }
        }
        return schedule;
    }

    void initiateTokens() {
        if (this.handler.getAuthCode() == null) {
            OrderMate.LOG.warn("Cannot proceed with tokens if auth code is null");
            this.gui.displayOkDialog("No Auth Code", "No auth code was received from server");
            return;
        }
        String endpoint = this.handler.getTokenEndpoint();
        RestHelper rs = new RestHelper();
        WebResource resource = this.createWebResource(rs, endpoint, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        resource = rs.addBasicAuth(resource, this.webConfig.getClientId(), this.webConfig.getClientSecret());
        Form form = new Form();
        form.add(GRANT_TYPE, AUTH_GRANT);
        form.add(CODE, this.handler.getAuthCode());
        form.add(REDIRECT_URI, this.getRedirectPath());
        ClientResponse response = (ClientResponse)resource.type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)form);
        if (response.getStatus() / 100 == 2) {
            if (this.handleTokenResponse(response)) {
                this.initiateTenants();
                if (XERO_AUTH_URL.equals(this.webConfig.getUrl())) {
                    Schedule schedule = OAuth2Client.getXeroTokenRefreshSchedule();
                    schedule.setRecurrence("0 */20 * * * ?");
                    schedule.setSystemState(SystemState.ACTIVE_STATE);
                    schedule.save();
                    OrderMate.LOG.info("Xero Token Refresh Schedule Enabled.");
                }
            }
        } else {
            this.gui.displayOkDialog("Tokens Invalid", "Cannot receive tokens from server");
            OrderMate.LOG.warn("Problem handling the OAuth2 tokens response:\r\n" + (String)response.getEntity(String.class));
        }
    }

    protected boolean handleTokenResponse(ClientResponse response) {
        OrderMate.LOG.info("Received access token response");
        String entity = (String)response.getEntity(String.class);
        try {
            this.saveTokens(new JSONObject(entity));
            return true;
        }
        catch (JSONException ex) {
            OrderMate.LOG.error("Error handling token response", (Throwable)ex);
            return false;
        }
    }

    private void saveTokens(JSONObject object) throws JSONException {
        String accessToken = object.getString(ACCESS_TOKEN);
        String refreshToken = object.getString("refresh_token");
        int expiry = object.getInt(EXPIRES_IN);
        this.webConfig.setAccessToken(accessToken);
        this.webConfig.setRefreshToken(refreshToken);
        Calendar cal = Calendar.getInstance();
        cal.add(13, expiry);
        this.webConfig.setExpires(cal.getTime());
        this.webConfig.save();
    }

    public void initiateTenants() {
        String endpoint = this.handler.getTenantsEndpoint();
        if (endpoint == null) {
            OrderMate.LOG.info("Will not do tenants endpoint, is null");
            return;
        }
        RestHelper rs = new RestHelper();
        WebResource resource = this.createWebResource(rs, endpoint, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        ClientResponse response = (ClientResponse)(resource = rs.addBearerAuth(resource, this.webConfig.getAccessToken())).type("application/json").get(ClientResponse.class);
        if (response.getStatus() / 100 == 2) {
            this.processTenantsResponse(response);
        } else {
            OrderMate.LOG.warn("Problem handling the OAuth2 tenants response:\r\n" + (String)response.getEntity(String.class));
        }
    }

    protected String getRedirectPath() {
        return "http://localhost:8228/oauth/auth";
    }

    void processAuthoriseResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean allGood = false;
        String output = null;
        try {
            output = this.handler.handleAuthResponse(req, resp);
            allGood = true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error processing the authorisation request", (Throwable)ex);
        }
        resp.setContentType("text/html");
        if (output == null) {
            output = allGood ? "Thank you for Authorising" : "There was an error Authorising";
        }
        resp.getOutputStream().write(HtmlUtils.html(output).getBytes());
        resp.getOutputStream().flush();
        this.closeAfterNSeconds(10);
        if (allGood) {
            this.initiateTokens();
        }
    }

    private void closeAfterNSeconds(final int n) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(n * 0);
                    OAuth2Client.this.stopServer();
                }
                catch (InterruptedException ie) {
                    OrderMate.LOG.info("Interrupted while stopping the server");
                    ie.printStackTrace();
                }
            }
        });
        t.start();
    }

    void processTenantsResponse(ClientResponse response) {
        String entity = (String)response.getEntity(String.class);
        OrderMate.LOG.info("TenantId Response : " + entity);
        String ERROR_TITLE = Internationalization.getLiteralFor("ERROR");
        String SUCCESS_TITLE = Internationalization.getLiteralFor("SUCCESS");
        String AUTH_SUCCESS_MSG = Internationalization.getLiteralFor("AUTH_SUCCESS");
        String AUTH_FAILED_MSG = Internationalization.getLiteralFor("XERO_AUTH_FAILED");
        String ERROR_DETAILS_MSG = Internationalization.getLiteralFor("XERO_ERROR_MESSAGE");
        try {
            String authEventId = this.getAuthenticationEventId();
            if (entity.startsWith("[")) {
                boolean authEventIdMatch = false;
                JSONArray array = new JSONArray(entity);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    String currentAuthEventId = object.getString("authEventId");
                    String currentTenantId = object.getString("tenantId");
                    String currentOrganisation = object.getString("tenantName");
                    if (!authEventId.equals(currentAuthEventId)) continue;
                    authEventIdMatch = true;
                    OrderMate.LOG.info("Tenant Information Stored is : " + object.toString());
                    this.webConfig.setTenantId(currentTenantId);
                    this.webConfig.setOrganisation(currentOrganisation);
                    this.webConfig.save();
                    this.gui.displayOkDialog(SUCCESS_TITLE, AUTH_SUCCESS_MSG);
                    this.statusSignal.emit(this.webConfig, true);
                }
                if (!authEventIdMatch) {
                    this.gui.displayErrorDialog(ERROR_TITLE, AUTH_FAILED_MSG, ERROR_DETAILS_MSG);
                    this.webConfig.delete();
                    this.statusSignal.emit(this.webConfig, false);
                    throw new Exception("Authorizing an organisation has failed!!");
                }
            } else {
                JSONObject jSONObject = new JSONObject(entity);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot parse Tenant object", (Throwable)ex);
        }
    }

    boolean processRefreshResponse(ClientResponse response) {
        String entity = (String)response.getEntity(String.class);
        OrderMate.LOG.info(entity);
        try {
            this.saveTokens(new JSONObject(entity));
            this.statusSignal.emit(this.webConfig, Boolean.TRUE);
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot parse object or invalid response", (Throwable)ex);
            return false;
        }
    }

    public boolean needsRefresh() {
        if (this.webConfig.getExpires() == null) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(13, 30);
        return this.webConfig.getExpires().before(cal.getTime());
    }

    public boolean canDisconnect() {
        return this.webConfig.getAccessToken() != null;
    }

    private void stopServer() {
        if (this.server != null) {
            this.server.tryStop();
            this.server = null;
        }
    }

    class OAuth2ReceiverServlet
    extends HttpServlet {
        OAuth2ReceiverServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            OAuth2Client.this.processAuthoriseResponse(req, resp);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            OAuth2Client.this.processAuthoriseResponse(req, resp);
        }
    }
}

