/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.oauth;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ordermate.OrderMate;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.integration.oauth.OAuth2ClientHandler;
import ordermate.integration.webservice.RestHelper;

public class XeroOAuth2Handler
implements OAuth2ClientHandler {
    private static final String CLIENT_ID = "CLIENTID";
    private static final String REDIRECT = "REDIRECT";
    private static final String STATE = "STATE";
    private static final String CODE = "code";
    private static final String AUTH_URL = "https://login.xero.com/identity/connect/authorize?response_type=code&client_id=CLIENTID&redirect_uri=REDIRECT&scope=offline_access openid profile email accounting.contacts accounting.transactions&state=STATE";
    private static final String TOKEN_URL = "https://identity.xero.com/connect/token";
    private static final String REVOKE_URL = "https://identity.xero.com/connect/revocation";
    private static final String TENANTS_URL = "https://api.xero.com/connections";
    private static final String TENANT_KEY = "xero-tenant-id";
    private String expectedState;
    private String authCode = null;

    @Override
    public String getAuthEndpoint(String redirectPath, WebserviceIntegrationConfig webConfig) {
        this.expectedState = Integer.toString((int)(Math.random() * 999999.0));
        String authEndpoint = AUTH_URL;
        authEndpoint = authEndpoint.replace(CLIENT_ID, webConfig.getClientId());
        String redir = redirectPath.replaceAll(":", "%3A").replaceAll("/", "%2F");
        authEndpoint = authEndpoint.replace(REDIRECT, redir);
        authEndpoint = authEndpoint.replace(STATE, this.expectedState);
        authEndpoint = authEndpoint.replaceAll(" ", "%20");
        return authEndpoint;
    }

    @Override
    public String handleAuthResponse(HttpServletRequest req, HttpServletResponse resp) {
        this.authCode = null;
        String returnedState = req.getParameter(STATE.toLowerCase());
        String code = req.getParameter(CODE);
        OrderMate.LOG.info("Received xero response, with state " + returnedState);
        if (this.expectedState.equals(returnedState) && !StringUtils.isEmpty(code)) {
            OrderMate.LOG.info("State matches, proceeding");
            this.authCode = code;
            return "Xero authorisation successful";
        }
        OrderMate.LOG.error(code + "=code " + this.expectedState + "=expectedState " + returnedState + "=returnedState");
        throw new IllegalStateException("Cannot process Xero response, state is not correct. Expected:" + this.expectedState + " but was " + returnedState);
    }

    @Override
    public String getTokenEndpoint() {
        return TOKEN_URL;
    }

    @Override
    public String getTenantsEndpoint() {
        return TENANTS_URL;
    }

    @Override
    public String getAuthCode() {
        return this.authCode;
    }

    @Override
    public String getRefreshEndpoint() {
        return TOKEN_URL;
    }

    @Override
    public WebResource modifyResource(WebResource resource, WebserviceIntegrationConfig webConfig) {
        resource.addFilter((ClientFilter)new RestHelper.HttpHeaderFilter(TENANT_KEY, webConfig.getTenantId()));
        return resource;
    }

    @Override
    public String getDisconnectEndpoint() {
        return REVOKE_URL;
    }
}

