/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinepayment;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.onlinepayment.OnlinePaymentRequest;
import ordermate.integration.onlinepayment.OnlinePaymentRequestor;
import ordermate.integration.onlinepayment.OnlinePaymentResponse;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OnlinePaymentIntegrator
extends UnicastRemoteObject
implements OnlinePaymentRequestor {
    private static OnlinePaymentIntegrator instance;
    protected static final int CONNECTION_TIMEOUT = 10000;
    protected static final int READ_TIMEOUT = 120000;
    protected static final int LOCK_TIMEOUT = 5000;
    protected static final int SEND_TIMEOUT = 2000;
    private static final String PIP = "PIP";
    private static final String OORBY_WEB_PATH = "ordermate/v1/payment/";
    private static final String APPS_PATH = "/apps";
    private static final String REQUEST_PATH = "/request";
    private static final String CANCEL_PATH = "/cancel";
    private X509TrustManager trustManager = new PassthroughX509TrustManager();
    private CloudBackConfig oorby;

    @Override
    public List<OnlinePaymentRequest> getPaymentRequests() throws RemoteException {
        block7: {
            if (!this.primeOorby()) {
                return null;
            }
            String url = StringUtils.ensureEndsWith(this.oorby.getWebConfig().getUrl(), "/");
            url = url + OORBY_WEB_PATH + SystemCurrentInfo.getInstance().getRedbackId() + APPS_PATH;
            OrderMate.LOG.info("Requesting payment apps from " + url);
            try {
                ClientResponse response = (ClientResponse)this.getResource(url).get(ClientResponse.class);
                if (response == null) break block7;
                String entity = (String)response.getEntity(String.class);
                OrderMate.LOG.info("Payment App Response:" + entity);
                if (response.getStatus() / 100 != 2) break block7;
                ArrayList<OnlinePaymentRequest> apps = new ArrayList<OnlinePaymentRequest>();
                try {
                    JSONArray jsonApps = new JSONArray(entity);
                    for (int i = 0; i < jsonApps.length(); ++i) {
                        JSONObject jsonApp = jsonApps.getJSONObject(i);
                        if (PIP.equals(jsonApp.getString("type"))) {
                            OnlinePaymentRequest app = new OnlinePaymentRequest(jsonApp.getString("id"), jsonApp.getString("label"), jsonApp.getString("icon"), jsonApp.getString("providerLabel"), jsonApp.getLong("linkId"), jsonApp.toString(), jsonApp.getBoolean("paymentIdRequired"), jsonApp.getBoolean("authCodeRequired"), jsonApp.getBoolean("expiryDateRequired"), jsonApp.getBoolean("issueDateRequired"));
                            apps.add(app);
                            continue;
                        }
                        OrderMate.LOG.info("Skipping " + jsonApp.getString("label") + " because it's " + jsonApp.getString("type"));
                    }
                }
                catch (JSONException ex) {
                    OrderMate.LOG.error("Cannot decipher incoming json", (Throwable)ex);
                }
                return apps;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("No response when getting payment apps", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public OnlinePaymentResponse requestPayment(OnlinePaymentRequest request, Long terminalId, Long accountId, String paymentId, String authCode, Date expiry, Date issue) throws RemoteException {
        if (!this.primeOorby()) {
            return null;
        }
        OrderMate.LOG.info("Servicing Online Payment Request for " + request.getAmount());
        if (request.getAmount() == null || request.getAmount().approximatelyEquals(Price.ZERO_DOLLAR)) {
            return null;
        }
        String url = StringUtils.ensureEndsWith(this.oorby.getWebConfig().getUrl(), "/");
        url = url + OORBY_WEB_PATH + SystemCurrentInfo.getInstance().getRedbackId() + REQUEST_PATH + "?requestId=" + request.getRequestId() + "&amount=" + request.getAmount().toString(false) + "&accountId=" + String.valueOf(accountId);
        url = this.appendIfNotNull(url, "terminalId", terminalId);
        url = this.appendIfNotNull(url, "paymentId", paymentId);
        url = this.appendIfNotNull(url, "authCode", authCode);
        url = this.appendIfNotNull(url, "expiryDate", expiry);
        url = this.appendIfNotNull(url, "issueDate", issue);
        OrderMate.LOG.info("Requesting online payment from " + url);
        try {
            ClientResponse response = (ClientResponse)this.getResource(url).post(ClientResponse.class, (Object)request.getToken());
            if (response != null) {
                String entity = (String)response.getEntity(String.class);
                OrderMate.LOG.info("Payment Request Response:" + entity);
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    OnlinePaymentResponse paymentResponse = (OnlinePaymentResponse)mapper.readValue(entity, OnlinePaymentResponse.class);
                    paymentResponse.setRequest(request);
                    return paymentResponse;
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot decipher incoming json", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Bad or no response for Payment Request", (Throwable)ex);
        }
        return null;
    }

    private String appendIfNotNull(String url, String queryParam, Object thing) {
        if (thing != null) {
            String value = thing instanceof Date ? DateTimeUtils.getSQLDateFormat().format(thing) : String.valueOf(thing);
            return url + "&" + queryParam + "=" + value;
        }
        return url;
    }

    @Override
    public boolean requestCancel(OnlinePaymentRequest request) throws RemoteException {
        if (!this.primeOorby()) {
            return false;
        }
        if (request == null) {
            return true;
        }
        String url = StringUtils.ensureEndsWith(this.oorby.getWebConfig().getUrl(), "/");
        url = url + OORBY_WEB_PATH + SystemCurrentInfo.getInstance().getRedbackId() + CANCEL_PATH + "?requestId=" + request.getRequestId();
        OrderMate.LOG.info("Cancelling online payment from " + url);
        try {
            ClientResponse response = (ClientResponse)this.getResource(url).post(ClientResponse.class, (Object)request.getToken());
            if (response != null) {
                String entity = (String)response.getEntity(String.class);
                OrderMate.LOG.info("Payment Cancel Response:" + entity);
                if (response.getStatus() / 100 == 2) {
                    try {
                        OrderMate.LOG.info("Got payment cancel response:" + entity);
                        ObjectMapper mapper = new ObjectMapper();
                        OnlinePaymentResponse paymentResponse = (OnlinePaymentResponse)mapper.readValue(entity, OnlinePaymentResponse.class);
                        return paymentResponse.isSuccess();
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Cannot decipher incoming json for cancel", (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Bad or no response for Payment Cancel", (Throwable)ex);
        }
        return false;
    }

    private boolean primeOorby() {
        if (this.oorby == null) {
            this.oorby = CloudBackConfig.getCloudBackConfig(CloudServerType.Oorby);
        }
        return this.oorby.isEnabled();
    }

    protected WebResource.Builder getResource(String url) {
        RestHelper rest = new RestHelper();
        WebResource resource = null;
        resource = url.startsWith("https:") ? rest.getSslResource(url, this.trustManager, 10000, 120000) : rest.getResource(url, 10000, 120000);
        return resource.header("Content-Type", (Object)"application/json");
    }

    public static Remote getInstance() {
        if (instance == null) {
            try {
                instance = new OnlinePaymentIntegrator();
            }
            catch (RemoteException ex) {
                OrderMate.LOG.error("Cannot instantiate OnlinePaymentIntegrator", (Throwable)ex);
            }
        }
        return instance;
    }
}

