/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinepayment;

import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.util.UUID;

public class OnlinePaymentRequest
implements Serializable {
    private final String appId;
    private final String label;
    private final String icon;
    private final String providerLabel;
    private final Long providerId;
    private final String requestId;
    private final String token;
    private final boolean paymentIdRequired;
    private final boolean authCodeRequired;
    private final boolean expiryDateRequired;
    private final boolean issueDateRequired;
    private Price amount;

    public OnlinePaymentRequest(String appId, String label, String icon, String providerLabel, Long providerId, String token, boolean requiresPaymentId, boolean requiresAuthCode, boolean requiresExpiryDate, boolean requiresIssueDate) {
        this.appId = appId;
        this.label = label;
        this.icon = icon;
        this.providerLabel = providerLabel;
        this.providerId = providerId;
        this.requestId = UUID.randomUUID().toString();
        this.token = token;
        this.paymentIdRequired = requiresPaymentId;
        this.authCodeRequired = requiresAuthCode;
        this.expiryDateRequired = requiresExpiryDate;
        this.issueDateRequired = requiresIssueDate;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getProviderLabel() {
        return this.providerLabel;
    }

    public Long getProviderLinkId() {
        return this.providerId;
    }

    public Long getProviderId() {
        return this.providerId;
    }

    public boolean isPaymentIdRequired() {
        return this.paymentIdRequired;
    }

    public boolean isAuthCodeRequired() {
        return this.authCodeRequired;
    }

    public boolean isExpiryDateRequired() {
        return this.expiryDateRequired;
    }

    public boolean isIssueDateRequired() {
        return this.issueDateRequired;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getToken() {
        return this.token;
    }

    public Price getAmount() {
        return this.amount;
    }

    public void setAmount(Price value) {
        this.amount = value;
    }

    public String toString() {
        return this.label + " - " + this.providerLabel;
    }
}

