/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales;

import java.io.InputStream;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.sales.Account;
import ordermate.database.users.User;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.OnlineOrderRetryWorker;
import ordermate.integration.onlinesales.posthandler.OnlineOrderPostHandler;
import ordermate.integration.onlinesales.posthandler.OnlineOrderPostHandlerFactory;
import ordermate.integration.onlinesales.posthandler.PaymentPostHandler;
import ordermate.integration.onlinesales.validator.OnlineSaleValidatorFactory;
import ordermate.jaxb.exporter.handlers.online.SalesAccountIntegrator;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountHandlerException;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPostwork;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public class OnlineAccountIntegrator {
    public OnlineOrderPostwork process(InputStream xmlStream) throws Exception {
        SalesAccountIntegrator accountIntegrator = new SalesAccountIntegrator(this.createIntegrationContext(true));
        OrderMateSale sale = (OrderMateSale)accountIntegrator.unmarshall(xmlStream);
        return this.doImport(accountIntegrator, sale);
    }

    public OnlineOrderPostwork process(OrderMateSale sale) throws Exception {
        return this.doImport(new SalesAccountIntegrator(this.createIntegrationContext(true)), sale);
    }

    public OrderMateSale examine(OrderMateSale sale) throws Exception {
        OnlineOrderPrework prework = new OnlineOrderPrework(sale, null, null, true, true);
        Account account = this.scanAhead(prework);
        if (account != null) {
            SalesAccountIntegrator accountIntegrator = new SalesAccountIntegrator(this.createIntegrationContext(false));
            return accountIntegrator.export(account);
        }
        return null;
    }

    public Account scanAhead(OnlineOrderPrework prework) throws AccountHandlerException {
        return OnlineSaleValidatorFactory.getValidatorFor(prework).validate(prework, this.createIntegrationContext(false));
    }

    protected OnlineOrderPostwork doImport(SalesAccountIntegrator accountIntegrator, OrderMateSale sale) throws Exception {
        if (!this.isBlockImportDuplicatesOn() || accountIntegrator.isSaleValid(sale)) {
            return this.getPostWorkOnImport(accountIntegrator, sale);
        }
        return new OnlineOrderPostwork(new OnlineOrderPrework(sale, AccountQueries.getOnlineOrderAccountForThirdParty(sale), sale.getExtOrderID() + " already exists", false, false), OnlineOrderPostwork.ProcessedStatus.Spam);
    }

    private boolean isBlockImportDuplicatesOn() {
        return SystemProperty.getInstance().isBlockDuplicateOnlineOrders();
    }

    private OnlineOrderPostwork getPostWorkOnImport(SalesAccountIntegrator accountIntegrator, OrderMateSale sale) throws Exception {
        OnlineOrderPrework prework = accountIntegrator.isImportReady(sale);
        if (prework.readyToImport) {
            return this.doActualImport(accountIntegrator, prework);
        }
        if (prework.locked) {
            return this.handleRetry(accountIntegrator, prework);
        }
        return new OnlineOrderPostwork(prework, OnlineOrderPostwork.ProcessedStatus.Failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OnlineOrderPostwork doActualImport(SalesAccountIntegrator accountIntegrator, OnlineOrderPrework prework) throws Exception {
        OnlineOrderPostwork postwork;
        Account account = accountIntegrator.importSale(prework.sale);
        if (account != null) {
            OnlineOrderPrework newPrework = new OnlineOrderPrework(prework.sale, account, prework.errorMessage, prework.readyToImport, prework.locked);
            Terminal contextTerminal = null;
            if (account.getCurrentSaveContext() != null) {
                contextTerminal = account.getCurrentSaveContext().getTerminal();
            }
            OnlineOrderPostHandler postHandler = new OnlineOrderPostHandlerFactory().makeHandler(account, prework.sale, this.createIntegrationContext(true, contextTerminal));
            try {
                postHandler.handlePostOnlineOrder(account, newPrework.sale);
                postwork = new OnlineOrderPostwork(newPrework, OnlineOrderPostwork.ProcessedStatus.Success);
            }
            finally {
                if (account.isLocked()) {
                    account.unlock();
                }
            }
        } else {
            postwork = new OnlineOrderPostwork(prework, OnlineOrderPostwork.ProcessedStatus.Failure);
        }
        return postwork;
    }

    private SalesXMLIntegrationContext createIntegrationContext(boolean forReal) {
        return this.createIntegrationContext(forReal, null);
    }

    private SalesXMLIntegrationContext createIntegrationContext(boolean forReal, Terminal terminal) {
        InventoryProfile profile = OnlineIntegrationConfig.getDefaultInstance().getInventoryProfile();
        if (profile == null) {
            throw new IllegalStateException("Cannot start integration without an inventory profile");
        }
        Terminal contextTerminal = Terminal.getServerMateTerminal();
        if (terminal != null) {
            contextTerminal = terminal;
        }
        return new SalesXMLIntegrationContext(profile, new EventContext(contextTerminal, User.getSystemUser()), forReal);
    }

    private OnlineOrderPostwork handleRetry(SalesAccountIntegrator accountIntegrator, OnlineOrderPrework prework) {
        OnlineOrderPostwork postwork;
        OnlineOrderPrework newPrework = prework;
        try {
            Account account = accountIntegrator.importSale(prework.sale);
            if (account != null) {
                newPrework = new OnlineOrderPrework(prework.sale, account, prework.errorMessage, prework.readyToImport, prework.locked);
            }
            this.scanAhead(newPrework);
            OnlineOrderRetryWorker.getInstance().putOnQueue(newPrework);
            postwork = new OnlineOrderPostwork(newPrework, OnlineOrderPostwork.ProcessedStatus.PendingRetry);
        }
        catch (AccountHandlerException ex) {
            newPrework.account.unlock();
            postwork = new OnlineOrderPostwork(newPrework, OnlineOrderPostwork.ProcessedStatus.Failure);
        }
        catch (Exception ex) {
            postwork = new OnlineOrderPostwork(newPrework, OnlineOrderPostwork.ProcessedStatus.Failure);
        }
        return postwork;
    }

    public boolean processPayment(OnlineOrderPrework prework, Account existing) {
        try {
            new PaymentPostHandler(this.createIntegrationContext(false)).handlePayment(existing, prework.sale);
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot make payment to existing account", (Throwable)ex);
            return false;
        }
    }
}

