/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.DateTimeUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public class OnlineOrderIntegrator {
    private static final String ONLINE_MENU = "all/onlinemenu/v1/";
    private static final String ONLINE_TABLE = "all/onlinetable/v1/";
    private static final String ONLINE_SITE = "all/onlinesite/v1/";
    private static final String SYNC = "/sync";
    public static final String HUNGRY_HUNGRY_MENU_IMPORT_LINK = "https://platform.hungryhungry.com";
    private static final int NUMBER_OF_DAYS_CHECK_FOR_LAST_ORDER = -60;
    private static volatile OnlineOrderIntegrator instance = null;
    private int menuRevisionCount;
    private int tableRevisionCount;
    private Long updateTime;
    private static final long DEFAULT_UPDATE_TIME = 300000L;
    private static final long UPDATE_RETRY = 60000L;
    private static final long UPDATE_DELAY = 1000L;
    private boolean running = false;

    private OnlineOrderIntegrator() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnlineOrderIntegrator getInstance() {
        if (instance != null) return instance;
        Class<OnlineOrderIntegrator> clazz = OnlineOrderIntegrator.class;
        synchronized (OnlineOrderIntegrator.class) {
            if (instance != null) return instance;
            instance = new OnlineOrderIntegrator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initialize() {
        this.menuRevisionCount = SystemCurrentInfo.getMenuRevisionCount();
        this.tableRevisionCount = SystemCurrentInfo.getTablesRevisionCount();
    }

    public void checkSync(final boolean siteSync) {
        if (!this.running && this.isRevisionChanged() || siteSync) {
            final Timer timer = new Timer();
            this.running = true;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Long timeLeft = OnlineOrderIntegrator.this.timeLeft();
                    if (timeLeft != null && timeLeft < 0L || siteSync) {
                        OnlineOrderIntegrator.this.syncThirdPartyOnlineMenu(new DummyGUIHandler(), OnlineOrderIntegrator.this.menuDiff(), OnlineOrderIntegrator.this.tableDiff(), siteSync);
                        OnlineOrderIntegrator.this.running = false;
                        timer.cancel();
                    }
                }
            }, 1000L, 60000L);
        }
    }

    public void updateRevisionCount() {
        this.updateTime = null;
        int newRevision = SystemCurrentInfo.getMenuRevisionCount();
        if (newRevision != this.menuRevisionCount) {
            this.updateTime = null;
            this.menuRevisionCount = newRevision;
        }
        if ((newRevision = SystemCurrentInfo.getTablesRevisionCount()) != this.tableRevisionCount) {
            this.tableRevisionCount = newRevision;
        }
    }

    public boolean menuDiff() {
        return this.menuRevisionCount == SystemCurrentInfo.getMenuRevisionCount();
    }

    public boolean tableDiff() {
        return this.tableRevisionCount == SystemCurrentInfo.getTablesRevisionCount();
    }

    public boolean isRevisionChanged() {
        try {
            int currentMenuRevision = SystemCurrentInfo.getMenuRevisionCount();
            int currentTableRevision = SystemCurrentInfo.getTablesRevisionCount();
            if (this.updateTime == null) {
                if (this.menuRevisionCount == currentMenuRevision && this.tableRevisionCount == currentTableRevision) {
                    return false;
                }
                this.startCountdown();
                this.menuRevisionCount = currentMenuRevision;
                this.tableRevisionCount = currentTableRevision;
                return true;
            }
            if (this.menuRevisionCount != currentMenuRevision || this.tableRevisionCount != currentTableRevision) {
                this.startCountdown();
                this.menuRevisionCount = currentMenuRevision;
                this.tableRevisionCount = currentTableRevision;
            }
            return true;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Unable to check revision count!", (Throwable)e);
            return false;
        }
    }

    public boolean isOnlineOrderingLicensed() {
        return PersistentLicenseManager.getInstance().getBoolean(LicenseType.OnlineOrderingIntegrationEnabled);
    }

    public boolean isHungryHungryIntegrationEnabled() {
        try {
            return this.isOnlineOrderingLicensed() && this.isHungryHungryImportRequiredWarning();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Unable to check online ordering license and import required warning!", (Throwable)e);
            return false;
        }
    }

    public boolean isHungryHungryImportRequiredWarning() {
        OnlineIntegrationConfig hungryHungryConfig = OnlineIntegrationConfig.getHungryHungryConfig();
        return hungryHungryConfig != null && hungryHungryConfig.isImportRequiredWarning();
    }

    public boolean shouldWarnForHHMenuImport() {
        return this.isHungryHungryIntegrationEnabled() && this.isRevisionChanged() && this.hasRecentHungryHungryOrder();
    }

    public boolean hasRecentHungryHungryOrder() {
        OnlineIntegrationConfig onlineIntegrationConfig = OnlineIntegrationConfig.getHungryHungryConfig();
        if (onlineIntegrationConfig == null) {
            return false;
        }
        Date lastOrderTime = onlineIntegrationConfig.getLastOrderTime();
        Date minDateForLastOrder = DateTimeUtils.addTime(new Date(), 5, -60);
        return lastOrderTime != null && lastOrderTime.compareTo(minDateForLastOrder) >= 0;
    }

    public void browseHHMenuImportURL() {
        try {
            Desktop.getDesktop().browse(new URI(HUNGRY_HUNGRY_MENU_IMPORT_LINK));
        }
        catch (IOException e) {
            OrderMate.LOG.error("Got IOException while browsing HungryHungry menu import URL! ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            OrderMate.LOG.error("Got URISyntaxException while browsing HungryHungry menu import URL! ", (Throwable)e);
        }
    }

    public boolean isThirdPartyOnlineOrderingEnabled() {
        CloudBackConfig oorbyConfig = CloudBackConfig.getCloudBackConfig(CloudServerType.Oorby);
        return oorbyConfig != null && oorbyConfig.isEnabled();
    }

    public void syncThirdPartyOnlineMenu(GuiHandler gui, boolean syncMenu, boolean syncTables, boolean syncSite) {
        this.updateTime = null;
        CloudBackConfig humpyConfig = CloudBackConfig.getCloudBackConfig(CloudServerType.HumpBack);
        if (humpyConfig == null || !humpyConfig.isEnabled()) {
            gui.displayOkDialog("Not Configured", "Third Party Online Ordering hasn't been configured");
            return;
        }
        ArrayList<String> endPoints = new ArrayList<String>();
        if (syncTables) {
            endPoints.add(ONLINE_TABLE);
        }
        if (syncMenu) {
            endPoints.add(ONLINE_MENU);
        }
        if (syncSite) {
            endPoints.add(ONLINE_SITE);
        }
        boolean allGood = true;
        for (String nextEndpoint : endPoints) {
            try {
                String url = humpyConfig.getWebConfig().getUrl() + nextEndpoint + SystemCurrentInfo.getInstance().getRedbackId() + SYNC;
                RestHelper rest = new RestHelper();
                WebResource resource = url.startsWith("https") ? rest.getSslResource(url, new PassthroughX509TrustManager(), 5000, 5000) : rest.getResource(url);
                ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
                String result = (String)response.getEntity(String.class);
                OrderMate.LOG.info("Online " + nextEndpoint + " Sync Result:" + result);
                if (!(allGood &= response.getStatus() / 100 == 2)) continue;
                this.updateRevisionCount();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot sync to " + nextEndpoint, (Throwable)ex);
            }
        }
        if (allGood) {
            gui.displayOkDialog("Sync Requested", "The Online Synchronisation request has been submitted");
        } else {
            gui.displayOkDialog("Sync Request Failed", "The Online Synchronisation request has failed. Please see logs.");
        }
    }

    private void startCountdown() {
        this.updateTime = System.currentTimeMillis() + 300000L;
    }

    public Long timeLeft() {
        if (this.updateTime != null) {
            return this.updateTime - System.currentTimeMillis();
        }
        return null;
    }
}

