/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.integration.onlinesales.OnlineAccountIntegrator;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public class OnlineOrderRetryWorker {
    private static final long DELAY = 5000L;
    private static OnlineOrderRetryWorker instance;
    private List<OnlineOrderPrework> toRetry = new ArrayList<OnlineOrderPrework>();
    private Timer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OnlineOrderRetryWorker getInstance() {
        Class<OnlineOrderRetryWorker> clazz = OnlineOrderRetryWorker.class;
        synchronized (OnlineOrderRetryWorker.class) {
            if (instance == null) {
                instance = new OnlineOrderRetryWorker();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private OnlineOrderRetryWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putOnQueue(OnlineOrderPrework prework) {
        OrderMate.LOG.info("Incoming retry " + prework.hashCode());
        List<OnlineOrderPrework> list = this.toRetry;
        synchronized (list) {
            for (OnlineOrderPrework nextPrework : this.toRetry) {
                if (nextPrework.sale != prework.sale) continue;
                return;
            }
            if (!this.toRetry.contains(prework)) {
                this.toRetry.add(prework);
            }
        }
        this.startWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryOrders() {
        ArrayList<OnlineOrderPrework> orders;
        List<OnlineOrderPrework> list = this.toRetry;
        synchronized (list) {
            orders = new ArrayList<OnlineOrderPrework>(this.toRetry);
        }
        if (!orders.isEmpty()) {
            OnlineAccountIntegrator integrator = new OnlineAccountIntegrator();
            for (OnlineOrderPrework prework : orders) {
                this.toRetry.remove(prework);
                this.retryOrder(integrator, prework);
            }
        }
        this.resetWorker();
    }

    private void retryOrder(OnlineAccountIntegrator integrator, OnlineOrderPrework prework) {
        try {
            OrderMate.LOG.info("Retrying online order " + prework.hashCode());
            integrator.process(prework.sale);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Couldn't retry the order, there was an exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker() {
        List<OnlineOrderPrework> list = this.toRetry;
        synchronized (list) {
            if (this.timer == null && !this.toRetry.isEmpty()) {
                this.timer = new Timer("Online Order Retry");
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        OnlineOrderRetryWorker.this.retryOrders();
                    }
                }, 5000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWorker() {
        List<OnlineOrderPrework> list = this.toRetry;
        synchronized (list) {
            if (this.toRetry.isEmpty()) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer.purge();
                    this.timer = null;
                }
            } else {
                this.timer = null;
                this.startWorker();
                OrderMate.LOG.info("NOT EMPTY");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfPendingOrders(long accountId) {
        Class<OnlineOrderRetryWorker> clazz = OnlineOrderRetryWorker.class;
        synchronized (OnlineOrderRetryWorker.class) {
            if (instance == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return 0;
            }
            int count = 0;
            List<OnlineOrderPrework> list = OnlineOrderRetryWorker.instance.toRetry;
            synchronized (list) {
                for (OnlineOrderPrework prework : OnlineOrderRetryWorker.instance.toRetry) {
                    if (prework.account.getID() != accountId) continue;
                    ++count;
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purge() {
        List<OnlineOrderPrework> list = this.toRetry;
        synchronized (list) {
            this.toRetry.clear();
            this.resetWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberPendingOrders() {
        List<OnlineOrderPrework> list = this.toRetry;
        synchronized (list) {
            return this.toRetry.size();
        }
    }
}

