/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.OnlineAccountIntegrator;
import ordermate.integration.onlinesales.OnlineTableUtil;
import ordermate.integration.onlinesales.TableBusyException;
import ordermate.jaxb.exporter.handlers.online.SalesAccountIntegrator;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPostwork;

public class OnlineTableAccountIntegrator
extends OnlineAccountIntegrator {
    private static final Map<Long, Semaphore> tablePermitMap = new ConcurrentHashMap<Long, Semaphore>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OnlineOrderPostwork doImport(SalesAccountIntegrator accountIntegrator, OrderMateSale sale) throws Exception {
        LogicalTable tableToOrderTo = OnlineTableUtil.getOrderTable(sale);
        if (tableToOrderTo == null) {
            return super.doImport(accountIntegrator, sale);
        }
        List<PhysicalTable> physicalTables = tableToOrderTo.getPhysicalTables();
        if (physicalTables.isEmpty()) {
            return super.doImport(accountIntegrator, sale);
        }
        PhysicalTable table = physicalTables.get(0);
        tablePermitMap.putIfAbsent(table.getID(), new Semaphore(1));
        Semaphore semaphore = tablePermitMap.get(table.getID());
        if (semaphore.tryAcquire()) {
            try {
                OnlineOrderPostwork onlineOrderPostwork = super.doImport(accountIntegrator, sale);
                return onlineOrderPostwork;
            }
            finally {
                semaphore.release();
            }
        }
        throw new TableBusyException("Name(" + table.getName() + ") Id(" + table.getID() + ")");
    }
}

