/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales;

import ordermate.OrderMate;
import ordermate.database.queries.tables.LogicalTableQueries;
import ordermate.database.queries.tables.PhysicalTableQueries;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.integration.jaxb.online.sales.OrderMateSale;

public class OnlineTableUtil {
    public static LogicalTable getOrderTable(OrderMateSale entity) {
        String exTableID = entity.getExtWebTableID();
        String tableName = entity.getExtWebTableName();
        LogicalTable tableToOrderTo = null;
        if (exTableID == null && tableName == null) {
            OrderMate.LOG.info("An OrderMateSale of OnlineTable type had a null table - deferring it to unallocated!");
        } else if (exTableID != null) {
            tableToOrderTo = LogicalTableQueries.getLogicalTableByPhysicalTableID(Long.parseLong(exTableID));
            if (tableToOrderTo == null) {
                OrderMate.LOG.warn("An OrderMateSale of OnlineTable type could not find a Logical table for physicalTable ID" + exTableID + " - deferring it to unallocated!");
            }
        } else if (tableName != null) {
            PhysicalTable table = PhysicalTableQueries.getPhysicalTableByGroupDashName(tableName);
            if (table != null) {
                tableToOrderTo = table.getLogicalTable();
            }
            if (tableToOrderTo == null && (tableToOrderTo = LogicalTableQueries.getLogicalTableByPhysicalTableNamePreferOnline(tableName)) == null) {
                OrderMate.LOG.warn("An OrderMateSale of OnlineTable type could not find a Logical table for Table name " + tableName + " - deferring it to unallocated!");
            }
        }
        return tableToOrderTo;
    }
}

