/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.notifier;

import au.com.diamondback.xmlintegration.sales.DiamondSale;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sun.jersey.api.client.ClientResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.integration.onlinesales.notifier.OnlineInterceptorHandler;
import ordermate.integration.onlinesales.notifier.OnlineUpdate;
import ordermate.integration.salesexport.DiamondSaleTranslator;
import org.apache.logging.log4j.Level;

public class DiamondBackInterceptorHandler
extends OnlineInterceptorHandler {
    private static final String SNAKEY_WEB_PATH = "sales/v1/general/";
    private static final String SALES = "/update";
    private DiamondSaleTranslator translator;
    private static final String ALL = "all";
    private String rbId;
    private boolean allAccounts = true;
    private Map<Long, DBSalesMod> idModCountMap = new HashMap<Long, DBSalesMod>();
    private static final int RETRY = 10;

    public DiamondBackInterceptorHandler() {
        super(CloudBackConfig.getCloudBackConfig(CloudServerType.DiamondBack));
        this.translator = new DiamondSaleTranslator();
        this.rbId = String.valueOf(SystemCurrentInfo.getInstance().getRedbackId());
        if (this.cloudConfig != null) {
            this.allAccounts = ALL.equals(this.cloudConfig.getCloudPropertyValue("send_accounts"));
        }
    }

    @Override
    boolean isEnabled() {
        return super.isEnabled();
    }

    public void accountChanged(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        if (this.isEnabled()) {
            if (PersistenceOperation.UPDATE.equals((Object)operation) && snapshot.get(Account.Properties.USER) != null) {
                OrderMate.LOG.log(Level.INFO, "DB Ignoring - user locked " + snapshot.getID());
                return;
            }
            Long id = snapshot.getID();
            if (id != null) {
                Long mod = snapshot.get(PersistentObject.Properties.MOD_COUNT);
                long modCount = mod == null ? 0L : mod;
                AccountState state = snapshot.get(Account.Properties.ACCOUNT_STATE);
                Date modDate = snapshot.get(Account.Properties.MOD_DATE_TIME) == null ? new Date(0L) : snapshot.get(Account.Properties.MOD_DATE_TIME);
                Price total = snapshot.get(Account.Properties.SAVED_TOTAL);
                DBSalesMod existingSales = this.idModCountMap.get(id);
                if (existingSales != null) {
                    if (existingSales.matches(modCount, modDate, state, total)) {
                        OrderMate.LOG.log(Level.INFO, "DB Dropping " + snapshot.getID() + " " + snapshot.get(Account.Properties.SAVED_TOTAL));
                        return;
                    }
                } else {
                    existingSales = new DBSalesMod();
                    this.idModCountMap.put(id, existingSales);
                }
                existingSales.set(modCount, modDate, state, total);
                OnlineUpdate update = new OnlineUpdate();
                update.id = id;
                update.clazz = Account.class;
                if (this.updateGateway.putIntoQueue(update)) {
                    OrderMate.LOG.info("DB Adding " + update.id + " " + snapshot.get(Account.Properties.SAVED_TOTAL) + " queue size " + this.updateGateway.getIncomingQueue().size());
                } else {
                    OrderMate.LOG.log(Level.WARN, "DiamondBack Snapshot NOT added " + update.id);
                }
            }
        }
    }

    @Override
    protected boolean doSend() {
        OrderMate.LOG.log(Level.INFO, "Sending updates: " + this.updateMap.size());
        ArrayList toSend = new ArrayList(this.updateMap.values());
        this.updateMap.clear();
        for (OnlineUpdate update : toSend) {
            boolean result = false;
            try {
                result = this.sendSale(update);
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "Problem while sending diamondback update:", (Throwable)ex);
            }
            if (result) continue;
            if (update.attempt < 10) {
                OrderMate.LOG.warn("Couldn't send data, not marked as sent, retrying");
                ++update.attempt;
                this.updateMap.put(update, update);
                continue;
            }
            OrderMate.LOG.warn("Couldn't send data after 10 attempts, not marked as sent, giving up");
        }
        if (this.idModCountMap.size() > 1000) {
            this.idModCountMap.clear();
        }
        OrderMate.LOG.log(Level.INFO, "DB Update sent, size is now: " + this.updateMap.size());
        return this.updateMap.isEmpty();
    }

    private boolean sendSale(OnlineUpdate update) {
        if (update.id == null) {
            return true;
        }
        Account account = PersistenceManager.getByID(update.id, Account.class);
        if (account == null) {
            return true;
        }
        DiamondSale sale = this.translator.translateAccount(account);
        if (!this.allAccounts && StringUtils.isEmpty(sale.getBookingId())) {
            return true;
        }
        String url = StringUtils.ensureEndsWith(this.cloudConfig.getWebConfig().getUrl(), "/");
        url = url + SNAKEY_WEB_PATH + this.rbId + SALES;
        String entity = null;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, false);
        try {
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)sale);
            writer.flush();
            entity = writer.toString();
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.ERROR, "Couldn't export diamondback sale:", (Throwable)ex);
        }
        OrderMate.LOG.info("Sending diamondback account " + update.id);
        boolean skipIt = false;
        if (skipIt) {
            OrderMate.LOG.info("Skipping DiamondBack Send");
            return true;
        }
        ClientResponse response = this.postResource(url, entity);
        if (response.getStatus() / 100 == 2) {
            OrderMate.LOG.info("Sent " + update.id);
            return true;
        }
        OrderMate.LOG.warn("Problem uploading Accounts to DiamondBack:" + response.getStatus() + " " + (String)response.getEntity(String.class));
        boolean tryAgain = response.getStatus() == 404;
        return tryAgain;
    }

    private class DBSalesMod {
        private long modCount;
        private Date modDate;
        private AccountState state;
        private Price total;

        private DBSalesMod() {
        }

        public boolean matches(long modCount2, Date modDate2, AccountState state2, Price total2) {
            if (this.modCount == modCount2) {
                return this.modDate.equals(modDate2) && this.state == state2 && this.total == total2;
            }
            return false;
        }

        public void set(long modCount2, Date modDate2, AccountState state2, Price total2) {
            this.modCount = modCount2;
            this.modDate = modDate2;
            this.state = state2;
            this.total = total2;
        }
    }
}

