/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.notifier;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.humpback.available.HMAvailable;
import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.stock.StockCount;
import ordermate.integration.onlinesales.notifier.OnlineInterceptorHandler;
import ordermate.integration.onlinesales.notifier.OnlineUpdate;
import ordermate.jaxb.exporter.XMLHelper;

public class HumpBackInterceptorHandler
extends OnlineInterceptorHandler {
    private static final String HUMPY_WEB_PATH = "pos/online/v1/";
    private static final String AVAILABLE = "/available";
    private final Map<Long, Pair<SalesQuantity, Long>> stockCountMap = new HashMap<Long, Pair<SalesQuantity, Long>>();

    HumpBackInterceptorHandler() {
        super(CloudBackConfig.getCloudBackConfig(CloudServerType.HumpBack));
        this.prime();
    }

    private void prime() {
        OnlineIntegrationIDStrategy strategy = SystemProperty.getInstance().getOnlineIntegrationIdStrategy();
        for (InventoryItemUnit unit : PersistenceManager.getObjectList(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).active(InventoryItemUnit.class).toString())) {
            StockCount count;
            Long idToPut = OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)strategy) ? unit.getMasterId() : unit.getID();
            if (idToPut == null || (count = PropertiedObject.PropsHelper.getPropertyValue(unit, InventoryItemUnit.Properties.STOCK_COUNT)) == null) continue;
            this.stockCountMap.put(count.getID(), new Pair<SalesQuantity, Long>(count.getQuantity(), idToPut));
        }
    }

    public void stockCountChanged(PersistentObjectSnapshot snapshot) {
        SalesQuantity oldQty = null;
        SalesQuantity newQty = snapshot.get(StockCount.Properties.QUANTITY);
        if (!this.stockCountMap.containsKey(snapshot.getID())) {
            InventoryItemUnit unit = PersistenceManager.getObject(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.STOCK_COUNT, snapshot.getID()).toString());
            if (unit == null) {
                return;
            }
            Long unitId = OnlineIntegrationIDStrategy.MASTER_ID == SystemProperty.getInstance().getOnlineIntegrationIdStrategy() ? unit.getMasterId() : unit.getID();
            if (unitId == null) {
                return;
            }
            this.stockCountMap.put(snapshot.getID(), new Pair<SalesQuantity, Long>(newQty, unitId));
        } else {
            oldQty = (SalesQuantity)this.stockCountMap.get((Object)snapshot.getID()).key;
        }
        this.stockCountMap.get((Object)snapshot.getID()).key = newQty;
        Boolean makeAvailable = null;
        if (oldQty != null && oldQty.lessThanOrEquals(SalesQuantity.ZERO) && (newQty == null || newQty.greaterThan(SalesQuantity.ZERO))) {
            makeAvailable = Boolean.TRUE;
        } else if ((oldQty == null || oldQty.greaterThan(SalesQuantity.ZERO)) && newQty != null && newQty.lessThanOrEquals(SalesQuantity.ZERO)) {
            makeAvailable = Boolean.FALSE;
        }
        if (makeAvailable != null) {
            OnlineUpdate update = new OnlineUpdate();
            update.clazz = InventoryItemUnit.class;
            update.id = (Long)this.stockCountMap.get((Object)snapshot.getID()).value;
            update.available = makeAvailable;
            this.updateGateway.putIntoQueue(update);
        }
    }

    @Override
    protected boolean doSend() {
        HMAvailable toSend = null;
        ArrayList<OnlineUpdate> updates = null;
        for (OnlineUpdate update : this.updateMap.values()) {
            if (!InventoryItemUnit.class.equals((Object)update.clazz)) continue;
            if (toSend == null) {
                toSend = new HMAvailable();
                toSend.setAvailable(update.available);
                updates = new ArrayList<OnlineUpdate>();
            }
            if (toSend.isAvailable() != update.available) continue;
            updates.add(update);
            toSend.getUnitIds().add(update.id.toString());
        }
        if (toSend == null) {
            return true;
        }
        if (!toSend.isAvailable()) {
            toSend.setStarting(XMLHelper.getDateType(new Date()));
            toSend.setEnding(XMLHelper.getDateType(DateTimeUtils.getEndOfDay(new Date())));
        }
        String url = StringUtils.ensureEndsWith(this.cloudConfig.getWebConfig().getUrl(), "/");
        url = url + HUMPY_WEB_PATH + SystemCurrentInfo.getInstance().getRedbackId() + AVAILABLE;
        OrderMate.LOG.info("Sending stock count to " + url);
        ClientResponse response = this.postResource(url, toSend);
        if (response.getStatus() / 100 == 2) {
            for (OnlineUpdate update : updates) {
                this.updateMap.remove(update);
            }
            return true;
        }
        OrderMate.LOG.warn("Problem uploading stock counts to Oorby:" + response.getStatus() + " " + (String)response.getEntity(String.class));
        return false;
    }

    void setStockCount(StockCount theCount, InventoryItemUnit theUnit) {
        this.stockCountMap.put(theCount.getID(), new Pair<SalesQuantity, Long>(theCount.getQuantity(), theUnit.getID()));
    }
}

