/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.notifier;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import javax.net.ssl.X509TrustManager;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.integration.onlinesales.notifier.OnlineUpdate;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

abstract class OnlineInterceptorHandler {
    protected static final int CONNECTION_TIMEOUT = 10000;
    protected static final int LOCK_TIMEOUT = 5000;
    protected static final int SEND_TIMEOUT = 2000;
    private static final int SIZE = 1000;
    private X509TrustManager trustManager = new PassthroughX509TrustManager();
    private Timer timer;
    protected final Map<OnlineUpdate, OnlineUpdate> updateMap = new HashMap<OnlineUpdate, OnlineUpdate>();
    protected CloudBackConfig cloudConfig;
    protected final Gateway<OnlineUpdate> updateGateway;
    private final Semaphore updateMapLock = new Semaphore(1);
    private final Semaphore timerLock = new Semaphore(1);

    OnlineInterceptorHandler(CloudBackConfig cloudConfig) {
        this.cloudConfig = cloudConfig;
        OnlineUpdateWorker worker = new OnlineUpdateWorker();
        OnlineUpdateNotifier notifier = new OnlineUpdateNotifier();
        this.updateGateway = new Gateway<OnlineUpdate>(worker, notifier, 1000);
        if (this.isEnabled()) {
            this.start();
        }
    }

    boolean isEnabled() {
        return this.cloudConfig != null && this.cloudConfig.isEnabled();
    }

    public void stop() {
        this.updateGateway.startService();
    }

    public void start() {
        this.updateGateway.startService();
    }

    void clear() {
        this.updateGateway.getIncomingQueue().clear();
        this.updateMap.clear();
    }

    private void restartTimer(int timeoutInMillis) {
        if (this.timerLock.tryAcquire()) {
            try {
                if (this.timer != null) {
                    this.timer.cancel();
                }
                this.timer = new Timer("Online Update");
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        OnlineInterceptorHandler.this.sendUpStatuses();
                    }
                }, timeoutInMillis);
            }
            finally {
                this.timerLock.release();
            }
        }
    }

    int queueSize() {
        return this.updateGateway.getIncomingQueue().size();
    }

    int mapSize() {
        return this.updateMap.size();
    }

    public boolean sendNow() {
        try {
            this.updateMapLock.acquire();
        }
        catch (InterruptedException ex) {
            OrderMate.LOG.error("Couldn't grab the lock to manualy upload data");
            return false;
        }
        try {
            OrderMate.LOG.info("Manually pushing up changes.");
            boolean ex = this.doSend();
            return ex;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot upload data for online orders", (Throwable)ex);
        }
        finally {
            this.updateMapLock.release();
        }
        return false;
    }

    private void sendUpStatuses() {
        try {
            this.updateMapLock.acquire();
        }
        catch (InterruptedException ex) {
            OrderMate.LOG.error("Couldn't grab the lock to upload data, retrying in 2000");
            this.restartTimer(2000);
            return;
        }
        try {
            boolean proceed;
            Thread.sleep(2000L);
            boolean bl = proceed = !this.updateMap.isEmpty();
            while (proceed) {
                proceed = this.doSend();
                if (!proceed) {
                    this.restartTimer(20000);
                    continue;
                }
                proceed = !this.updateMap.isEmpty();
                if (!proceed) continue;
                OrderMate.LOG.warn("Continuing to send, updateSet isn't empty:" + this.updateMap.size());
            }
            OrderMate.LOG.info("Finished sending statuses");
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot upload data for online orders", (Throwable)ex);
        }
        finally {
            this.updateMapLock.release();
        }
    }

    protected ClientResponse postResource(String url, Object toSend) {
        RestHelper rest = new RestHelper();
        WebResource resource = null;
        resource = url.startsWith("https:") ? rest.getSslResource(url, this.trustManager, 10000, 10000) : rest.getResource(url);
        return (ClientResponse)resource.header("Content-Type", (Object)"application/json").post(ClientResponse.class, toSend);
    }

    protected abstract boolean doSend() throws Exception;

    private class OnlineUpdateWorker
    implements GatewayProcessor<OnlineUpdate> {
        private OnlineUpdateWorker() {
        }

        @Override
        public boolean processIncoming(OnlineUpdate toProcess) {
            if (toProcess == null) {
                return true;
            }
            try {
                OnlineInterceptorHandler.this.updateMapLock.acquire();
                OnlineUpdate existing = OnlineInterceptorHandler.this.updateMap.get(toProcess);
                if (existing != null) {
                    toProcess.attempt = existing.attempt;
                }
                OnlineInterceptorHandler.this.updateMap.put(toProcess, toProcess);
                OnlineInterceptorHandler.this.updateMapLock.release();
            }
            catch (InterruptedException ex) {
                OrderMate.LOG.error("Interrupted while getting Map Lock for Online Update Interceptor", (Throwable)ex);
            }
            return true;
        }
    }

    private class OnlineUpdateNotifier
    implements GatewayNotifier<OnlineUpdate> {
        private OnlineUpdateNotifier() {
        }

        @Override
        public void notifyProcess(OnlineUpdate processedValue, boolean processSuccessful) {
            if (processSuccessful) {
                OnlineInterceptorHandler.this.restartTimer(2000);
            }
        }
    }
}

