/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.notifier;

import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import ordermate.OrderMate;
import ordermate.database.diff.OnlineMenuVersionControl;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.stock.StockCount;
import ordermate.database.tables.TableGroup;
import ordermate.integration.onlinesales.OnlineOrderIntegrator;
import ordermate.integration.onlinesales.notifier.DiamondBackInterceptorHandler;
import ordermate.integration.onlinesales.notifier.HumpBackInterceptorHandler;
import ordermate.integration.onlinesales.notifier.OorbyInterceptorHandler;
import ordermate.integration.onlinesales.notifier.PiggyInterceptorHandler;

public class OnlineUpdateInterceptor
implements PersistenceListener {
    private static OnlineUpdateInterceptor instance;
    private boolean enabled = false;
    private HumpBackInterceptorHandler humpyInterceptor;
    private OorbyInterceptorHandler oorbyInterceptor;
    private PiggyInterceptorHandler piggyInterceptor;
    private DiamondBackInterceptorHandler snakeyInterceptor;

    public static OnlineUpdateInterceptor getInstance() {
        if (instance == null) {
            instance = new OnlineUpdateInterceptor();
        }
        return instance;
    }

    private OnlineUpdateInterceptor() {
        this.restart();
    }

    public void stop() {
        if (this.humpyInterceptor != null) {
            this.humpyInterceptor.stop();
            this.oorbyInterceptor.stop();
            this.snakeyInterceptor.stop();
            this.piggyInterceptor.stop();
        }
    }

    public void start() {
        this.humpyInterceptor.start();
        this.oorbyInterceptor.start();
        this.snakeyInterceptor.start();
        this.piggyInterceptor.start();
    }

    public void restart() {
        this.stop();
        this.oorbyInterceptor = new OorbyInterceptorHandler();
        this.piggyInterceptor = new PiggyInterceptorHandler();
        this.humpyInterceptor = new HumpBackInterceptorHandler();
        this.snakeyInterceptor = new DiamondBackInterceptorHandler();
        this.enabled = this.oorbyInterceptor.isEnabled() || this.humpyInterceptor.isEnabled() || this.snakeyInterceptor.isEnabled() || this.piggyInterceptor.isEnabled();
        OrderMate.LOG.info("Online Update Interceptor alive? " + this.enabled);
    }

    @Override
    public void objectChanged(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        if (this.enabled && (PersistenceOperation.SAVE.equals((Object)operation) || PersistenceOperation.UPDATE.equals((Object)operation))) {
            if (Account.class.isAssignableFrom(snapshot.getObjectType())) {
                this.oorbyInterceptor.accountChanged(snapshot);
                this.snakeyInterceptor.accountChanged(snapshot, operation);
            } else if (FinanceTransaction.class.isAssignableFrom(snapshot.getObjectType())) {
                this.piggyInterceptor.transactionChanged(snapshot);
            } else if (StockCount.class.isAssignableFrom(snapshot.getObjectType()) && this.humpyInterceptor.isEnabled()) {
                this.humpyInterceptor.stockCountChanged(snapshot);
            } else if ((OnlineMenuVersionControl.class.isAssignableFrom(snapshot.getObjectType()) || TableGroup.class.isAssignableFrom(snapshot.getObjectType()) || Terminal.class.isAssignableFrom(snapshot.getObjectType())) && this.humpyInterceptor.isEnabled()) {
                boolean siteSync = Terminal.class.isAssignableFrom(snapshot.getObjectType());
                OnlineOrderIntegrator.getInstance().checkSync(siteSync);
            }
        }
    }

    void clear() {
        this.oorbyInterceptor.clear();
        this.humpyInterceptor.clear();
        this.snakeyInterceptor.clear();
        this.piggyInterceptor.clear();
    }

    HumpBackInterceptorHandler getHumpBackInterceptorHandler() {
        return this.humpyInterceptor;
    }

    OorbyInterceptorHandler getOorbyInterceptorHandler() {
        return this.oorbyInterceptor;
    }

    public DiamondBackInterceptorHandler getDiamondBackInterceptorHandler() {
        return this.snakeyInterceptor;
    }

    public PiggyInterceptorHandler getPiggyBackInterceptorHandler() {
        return this.piggyInterceptor;
    }
}

