/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.notifier;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.Account;
import ordermate.integration.jaxb.online.order.OnlineOrderResult;
import ordermate.integration.jaxb.online.status.OnlineOrderStatusEntry;
import ordermate.integration.jaxb.online.status.OnlineOrderStatusList;
import ordermate.integration.onlinesales.notifier.OnlineInterceptorHandler;
import ordermate.integration.onlinesales.notifier.OnlineUpdate;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.webresource.online.AccountStatusHelper;
import ordermate.webresource.online.OnlineOrderResultCode;

public class OorbyInterceptorHandler
extends OnlineInterceptorHandler {
    private static final String OORBY_WEB_PATH = "ordermate/v1/update/";
    private static final String STATUS_PATH = "/status";
    private AccountStatusHelper helper = new AccountStatusHelper();

    OorbyInterceptorHandler() {
        super(CloudBackConfig.getCloudBackConfig(CloudServerType.Oorby));
    }

    public void accountChanged(PersistentObjectSnapshot snapshot) {
        Long id;
        if (this.isEnabled() && (id = snapshot.getID()) != null && !StringUtils.isEmpty(snapshot.get(Account.Properties.SOURCE))) {
            OnlineUpdate update = new OnlineUpdate();
            update.id = id;
            update.clazz = Account.class;
            this.updateGateway.putIntoQueue(update);
        }
    }

    @Override
    protected boolean doSend() throws Exception {
        String source = null;
        ArrayList<OnlineUpdate> updates = new ArrayList<OnlineUpdate>();
        for (OnlineUpdate update : this.updateMap.values()) {
            Object account;
            if (!Account.class.equals((Object)update.clazz) || (account = PersistenceManager.getByID(update.id, Account.class)) == null) continue;
            if (source == null) {
                source = ((Account)account).getSource();
            }
            if (source == null || !source.equals(((Account)account).getSource())) continue;
            updates.add(update);
            update.account = account;
        }
        if (updates.isEmpty()) {
            this.updateMap.clear();
            return true;
        }
        OnlineOrderResult toSend = new OnlineOrderResult();
        toSend.setResultCode(BigInteger.valueOf(OnlineOrderResultCode.SUCCESS.getCode()));
        toSend.setResultDesc(OnlineOrderResultCode.SUCCESS.name());
        OnlineOrderStatusList statusList = new OnlineOrderStatusList();
        statusList.setOrderSource(source);
        toSend.setStatusList(statusList);
        for (OnlineUpdate nextUpdate : updates) {
            OnlineOrderStatusEntry entry = this.helper.getStatus(nextUpdate.id, source);
            entry.setCreationDatetime(XMLHelper.getDateType(nextUpdate.account.getCreationDateTime()));
            this.helper.doStatus(nextUpdate.account, entry);
            statusList.getOnlineOrderStatus().add(entry);
        }
        String url = StringUtils.ensureEndsWith(this.cloudConfig.getWebConfig().getUrl(), "/");
        url = url + OORBY_WEB_PATH + SystemCurrentInfo.getInstance().getRedbackId() + STATUS_PATH;
        OrderMate.LOG.info("Sending account status to " + url);
        ClientResponse response = this.postResource(url, toSend);
        if (response.getStatus() / 100 == 2) {
            for (OnlineUpdate update : updates) {
                this.updateMap.remove(update);
            }
            return true;
        }
        OrderMate.LOG.warn("Problem uploading Accounts to Oorby:" + response.getStatus() + " " + (String)response.getEntity(String.class));
        boolean tryAgain = response.getStatus() / 100 == 4;
        Thread.sleep(2000L);
        if (!tryAgain) {
            for (OnlineUpdate update : updates) {
                this.updateMap.remove(update);
            }
        }
        return tryAgain;
    }
}

