/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.notifier;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.piggy.PiggyRequestBuilder;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.util.Pair;
import au.com.ordermate.xmlintegration.piggy.GuestSuggestion;
import au.com.ordermate.xmlintegration.piggy.PaymentInfo;
import au.com.ordermate.xmlintegration.piggy.PiggyRequest;
import au.com.ordermate.xmlintegration.piggy.PiggyResponse;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudBackProperty;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.integration.onlinesales.notifier.OnlineInterceptorHandler;
import ordermate.integration.onlinesales.notifier.OnlineUpdate;
import ordermate.integration.piggy.PiggyResult;
import ordermate.integration.piggy.PiggyWebResourceHelper;

public class PiggyInterceptorHandler
extends OnlineInterceptorHandler {
    private static final String PAYMENT_PATH = "integrator/v1/sendNonRoomPayment";
    private static final String REFUND_PATH = "integrator/v1/refundNonRoomPayment";
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private Date nextResentDT;

    public synchronized Date getNextResentDT() {
        return this.nextResentDT != null ? new Date(this.nextResentDT.getTime()) : null;
    }

    public synchronized void setNextResentDT(Date nextResentDT) {
        this.nextResentDT = nextResentDT != null ? new Date(nextResentDT.getTime()) : null;
    }

    PiggyInterceptorHandler() {
        super(CloudBackConfig.getCloudBackConfig(CloudServerType.PiggyBack));
        this.setNextResentDT(PiggyInterceptorHandler.getNextResendTime());
        long initResendTime = this.getNextResentDT().getTime() - System.currentTimeMillis();
        this.scheduler.schedule(new ResendFailedPaymentsTask(), initResendTime, TimeUnit.MILLISECONDS);
    }

    private static Date getNextResendTime() {
        Calendar now = Calendar.getInstance();
        Calendar nextExecution = (Calendar)now.clone();
        nextExecution.set(12, 59);
        nextExecution.set(13, 59);
        nextExecution.set(14, 0);
        if (now.after(nextExecution)) {
            nextExecution.add(11, 1);
        }
        return nextExecution.getTime();
    }

    @Override
    boolean isEnabled() {
        CloudBackConfig config = CloudBackConfig.getCloudBackConfig(CloudServerType.PiggyBack);
        if (config == null) {
            return false;
        }
        if (!this.cloudConfig.isEnabled()) {
            return false;
        }
        CloudBackProperty enablePostPaymentsProp = null;
        for (CloudBackProperty cloudBackProperty : config.getCloudProperties()) {
            if (!"EnablePostPayments".equals(cloudBackProperty.getKey())) continue;
            enablePostPaymentsProp = cloudBackProperty;
            break;
        }
        if (enablePostPaymentsProp != null) {
            try {
                return Boolean.parseBoolean(enablePostPaymentsProp.getValue());
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public void transactionChanged(PersistentObjectSnapshot snapshot) {
        if (!this.isEnabled()) {
            return;
        }
        Long id = snapshot.getID();
        if (id != null) {
            OnlineUpdate update = new OnlineUpdate();
            update.id = id;
            update.clazz = FinanceTransaction.class;
            this.updateGateway.putIntoQueue(update);
        }
    }

    @Override
    protected boolean doSend() throws Exception {
        if (!this.isEnabled()) {
            return true;
        }
        ArrayList<OnlineUpdate> updates = new ArrayList<OnlineUpdate>();
        for (OnlineUpdate update : this.updateMap.values()) {
            FinanceTransaction transaction;
            if (!FinanceTransaction.class.equals((Object)update.clazz) || (transaction = PersistenceManager.getByID(update.id, FinanceTransaction.class)) == null) continue;
            if (transaction.isActive()) {
                this.sendPayment(transaction);
            }
            updates.add(update);
        }
        if (updates.isEmpty()) {
            this.updateMap.clear();
            return true;
        }
        for (OnlineUpdate nextUpdate : updates) {
            this.updateMap.remove(nextUpdate);
        }
        return true;
    }

    private List<FinanceTransaction> getUnsentPiggyNonRoomPayments() {
        Date midnight = DateTimeUtils.getStartOfDay(this.getNextResentDT());
        Date nextMidnight = DateTimeUtils.addTime(midnight, 5, 1);
        ObjectQuery query = Query.select(FinanceTransaction.class).greaterThanOrEqual(FinanceTransaction.Properties.CREATION_TIME, midnight, SQLDateType.DATE).lessThan(FinanceTransaction.Properties.CREATION_TIME, nextMidnight, SQLDateType.DATE).isNull(FinanceTransaction.Properties.PIGGY_PAYMENT_TIME);
        OrderMate.LOG.info("Query for getting Unsent Non-Room Piggy Payments query = " + query.copy());
        List<FinanceTransaction> unsentPiggyPayments = PersistenceManager.getObjectList(FinanceTransaction.class, query.toString(), null);
        OrderMate.LOG.info("There is/are " + unsentPiggyPayments.size() + " unsent Piggy Non Room Payment(s)");
        return unsentPiggyPayments;
    }

    private PaymentInfo getPiggyPayment(FinanceTransaction transaction) {
        FinanceUnit subType = transaction.getSubType();
        PaymentInfo piggyPayment = new PaymentInfo();
        if (transaction.getAccount() != null) {
            piggyPayment.setAccountId(transaction.getAccount().getID());
        }
        piggyPayment.setAmount(transaction.getPaidTotal().toBigDecimal());
        piggyPayment.setPaymentTime(Long.valueOf(transaction.getCreationTime().getTime()));
        piggyPayment.setPaymentType(transaction.getType());
        piggyPayment.setSubType(subType.getLabel());
        piggyPayment.setTip(transaction.getTip().toBigDecimal());
        return piggyPayment;
    }

    public void sendPayment(FinanceTransaction transaction) {
        if (transaction.getPiggyPaymentTime() != null) {
            return;
        }
        Long cashAccountId = SystemProperty.getInstance().getRmsCashAccountId();
        PaymentInfo payment = this.getPiggyPayment(transaction);
        PiggyRequestBuilder piggyRequestBuilder = new PiggyRequestBuilder();
        piggyRequestBuilder.setStoreId(SystemCurrentInfo.getInstance().getRedbackId());
        piggyRequestBuilder.setNonRoomAccountPayment(payment);
        piggyRequestBuilder.setAccountId(cashAccountId);
        PiggyRequest piggyRequest = piggyRequestBuilder.buildSendNonRoomPayment();
        PiggyWebResourceHelper webResourceHelper = new PiggyWebResourceHelper();
        try {
            String paymentType = "Payment";
            String path = PAYMENT_PATH;
            if (payment.getAmount().compareTo(BigDecimal.ZERO) < 0) {
                path = REFUND_PATH;
                paymentType = "Refund";
            }
            WebResource.Builder resource = webResourceHelper.setupResource(path, new Pair[0]);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)resource.entity((Object)piggyRequest)).post(ClientResponse.class);
            OrderMate.LOG.info("Send " + paymentType + " To PiggyBack:\n" + JSONUtil.toJson(piggyRequest));
            if (clientResponse == null) {
                OrderMate.LOG.error("Cannot Send Non Room Sales to Piggy");
                return;
            }
            if (clientResponse.getStatus() / 100 == 2) {
                PiggyResult piggyResult = new PiggyResult(ClientResponse.Status.OK.getStatusCode(), ClientResponse.Status.OK.getReasonPhrase(), (PiggyResponse)clientResponse.getEntity(PiggyResponse.class), null);
                transaction.setPiggyPaymentTime(new Date());
                List piggyResponseDetails = piggyResult.getPiggyResponse().getGuestSuggestions();
                if (piggyResponseDetails != null && piggyResponseDetails.size() > 0) {
                    GuestSuggestion piggyResponseDetail = (GuestSuggestion)piggyResponseDetails.get(0);
                    transaction.setExtTransactionId(piggyResponseDetail.getExtTxnId());
                }
                transaction.saveChild();
            } else {
                OrderMate.LOG.warn("Problem Sending Non Room Payment to Piggy: " + clientResponse.getStatus() + " " + (String)clientResponse.getEntity(String.class));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Problem Sending Non Room Payment to Piggy.", (Throwable)ex);
        }
    }

    class ResendFailedPaymentsTask
    implements Runnable {
        ResendFailedPaymentsTask() {
        }

        @Override
        public void run() {
            if (!PiggyInterceptorHandler.this.isEnabled()) {
                return;
            }
            OrderMate.LOG.info("ResendFailedPayments executed at: " + new Date());
            List transactions = PiggyInterceptorHandler.this.getUnsentPiggyNonRoomPayments();
            PiggyInterceptorHandler.this.setNextResentDT(PiggyInterceptorHandler.getNextResendTime());
            long nextResendTime = PiggyInterceptorHandler.getNextResendTime().getTime() - System.currentTimeMillis();
            PiggyInterceptorHandler.this.scheduler.schedule(new ResendFailedPaymentsTask(), nextResendTime, TimeUnit.MILLISECONDS);
            for (FinanceTransaction transaction : transactions) {
                PiggyInterceptorHandler.this.sendPayment(transaction);
            }
        }
    }
}

