/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.gui.SimpleSaveAccount;
import ordermate.integration.jaxb.online.sales.OnlinePrePayment;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.OnlineAccountEventContext;
import ordermate.integration.onlinesales.posthandler.OnlineOrderPostHandler;
import ordermate.integration.onlinesales.posthandler.payment.OnlineAccountPrePayment;
import ordermate.integration.onlinesales.posthandler.payment.OnlinePrePaymentFactory;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;

abstract class AbstractPostHandler
implements OnlineOrderPostHandler {
    protected final SalesXMLIntegrationContext integrationContext;
    protected final String CONFIRM_ADDRESS_STRING = "(PLEASE CALL CUSTOMER TO CONFIRM THE ADDRESS)";
    protected Account account;
    protected OrderMateSale sale;

    AbstractPostHandler(SalesXMLIntegrationContext context) {
        this.integrationContext = context;
    }

    @Override
    public void handlePostOnlineOrder(Account theAccount, OrderMateSale theSale) throws Exception {
        List<Account> salesAccounts;
        this.account = theAccount;
        this.sale = theSale;
        this.account.setExtOrderID(theSale.getExtOrderID());
        this.account.setExtHRef(theSale.getExtHRef());
        this.account.setExtOrderDateTime(theSale.getOrderDate().toGregorianCalendar().getTime());
        this.account.setExtDocketHRef(theSale.getExtXMLDocketHRef());
        this.account.setSource(theSale.getExtSourceName());
        this.account.setExtOrigin(theSale.getExtChannelName());
        Customer compareCustomer = this.account.getCustomer() != null && this.account.getCustomer().getID() != null ? PersistenceManager.getByID(this.account.getCustomer().getID(), Customer.class) : null;
        if (compareCustomer != null && !compareCustomer.getAddress().equals(this.account.getCustomer().getAddress()) && (salesAccounts = PersistenceManager.getObjectList(Account.class, Query.select(Account.class).equals(Account.Properties.CUSTOMER, this.account.getCustomer()).equals(Account.Properties.TRADING_DAY, this.account.getTradingDay()).toString())).size() > 0) {
            for (Account a : salesAccounts) {
                if (this.checkCommentContainsConfirmationStringSafe(a.getComment()) || !a.getReceiptState().equals(Account.ReceiptPrintState.RECEIPT_NOT_PRINTED)) continue;
                if (!a.isLocked(this.integrationContext.getEventContext().getUser())) {
                    a.lock(this.integrationContext.getEventContext().getUser());
                }
                if (a.getComment() == null) {
                    a.setComment("(PLEASE CALL CUSTOMER TO CONFIRM THE ADDRESS)");
                } else {
                    a.setComment(a.getComment() + " " + "(PLEASE CALL CUSTOMER TO CONFIRM THE ADDRESS)");
                }
                a.save();
                a.unlock();
            }
            if (this.account.getComment() == null) {
                this.account.setComment("(PLEASE CALL CUSTOMER TO CONFIRM THE ADDRESS)");
            } else if (!this.checkCommentContainsConfirmationStringSafe(this.account.getComment())) {
                this.account.setComment(this.account.getComment() + " " + "(PLEASE CALL CUSTOMER TO CONFIRM THE ADDRESS)");
            }
        }
        OnlineIntegrationConfig config = OnlineIntegrationConfig.getDefaultInstance();
        config.save();
        this.checkValid();
        this.setEta();
        this.saveAccount();
    }

    protected abstract void checkValid() throws Exception;

    protected abstract void setEta();

    protected abstract void saveAccount();

    protected void doPaid() {
        OnlinePrePaymentFactory factory = new OnlinePrePaymentFactory();
        factory.makePaymentMethod(this.sale, this.createEventContext()).handleAccountPayment(this.account, this.integrationContext.getEventContext().getUser());
    }

    protected OnlineAccountEventContext createEventContext() {
        VirtualPrinter receiptPrinter = this.getReceiptPrinterWithName(this.sale.getReceiptPrinterName());
        ArrayList<OnlineAccountPrePayment> payments = new ArrayList<OnlineAccountPrePayment>();
        if (this.sale.getPayments().isEmpty() && Boolean.TRUE.equals(this.sale.isIsPaid())) {
            OrderMate.LOG.info("Online Account marked as paid in full, with no payment information. Making one fully paying transaction");
            Price tip = this.sale.getTotalTip() != null ? new Price(this.sale.getTotalTip(), 0.01) : Price.ZERO_DOLLAR;
            Price totalPrice = new Price(this.sale.getTotalPrice().doubleValue(), 0.01);
            payments.add(new OnlineAccountPrePayment(this.getCashDrawerWithName(this.sale.getCashdrawerName()), this.getFinanceUnitWithName(this.sale.getPaymentType()), totalPrice, tip, null, this.sale.getExtSourceName(), null));
        } else {
            OrderMate.LOG.info("Online Account with incoming payments.");
            Price tip = this.sale.getTotalTip() != null ? new Price(this.sale.getTotalTip(), 0.01) : Price.ZERO_DOLLAR;
            for (OnlinePrePayment prePayment : this.sale.getPayments()) {
                Price surcharge = null;
                if (prePayment.getTip() != null) {
                    tip = new Price(prePayment.getTip(), 0.01);
                }
                if (prePayment.getSurcharge() != null) {
                    surcharge = new Price(prePayment.getSurcharge(), 0.01);
                }
                OnlineAccountPrePayment payment = new OnlineAccountPrePayment(this.getCashDrawerWithName(prePayment.getCashdrawerName()), this.getFinanceUnitWithName(prePayment.getPaymentType()), new Price(prePayment.getAmount(), 0.01), tip, surcharge, this.sale.getExtSourceName(), prePayment.getReference());
                payments.add(payment);
                tip = Price.ZERO_DOLLAR;
            }
        }
        return new OnlineAccountEventContext(this.integrationContext.getEventContext(), receiptPrinter, this.sale, payments);
    }

    private CashDrawer getCashDrawerWithName(String cashdrawerName) {
        if (cashdrawerName != null && !cashdrawerName.isEmpty()) {
            ObjectQuery cashdrawerQry = Query.select(CashDrawer.class).equals(CashDrawer.Properties.LABEL, cashdrawerName).active(CashDrawer.class).limit(1);
            return PersistenceManager.getObject(CashDrawer.class, cashdrawerQry.toString(), null);
        }
        return null;
    }

    private VirtualPrinter getReceiptPrinterWithName(String receiptPrinterName) {
        List<VirtualPrinter> receiptPrinters;
        ObjectQuery receiptPrinterQry;
        VirtualPrinter receiptPrinter = null;
        if (receiptPrinterName != null && !receiptPrinterName.isEmpty() && (receiptPrinter = PersistenceManager.getObject(VirtualPrinter.class, (receiptPrinterQry = Query.select(VirtualPrinter.class).equals(VirtualPrinter.Properties.LABEL, receiptPrinterName).limit(1)).toString(), null)) == null && (receiptPrinters = Terminal.getServerMateTerminal().getAvailableReceiptPrinters()).size() > 0) {
            OrderMate.LOG.info("Returing 1st available receipt printer " + receiptPrinters.get(0).getLabel() + " since the requested printer with name : " + receiptPrinterName + " is not available");
            receiptPrinter = receiptPrinters.get(0);
        }
        return receiptPrinter;
    }

    private FinanceUnit getFinanceUnitWithName(String paymentTypeName) {
        if (paymentTypeName != null && !paymentTypeName.isEmpty()) {
            FinanceUnit unit = FinanceUnit.getUnitForNameIgnoreSystemState(paymentTypeName);
            if (unit == null) {
                FinanceUnit newUnit = new FinanceUnit(paymentTypeName, FinanceUnit.WEB_TYPE, false);
                FinanceUnit protoUnit = FinanceUnit.getDefaultUnitFor(FinanceUnit.WEB_TYPE);
                if (protoUnit != null) {
                    newUnit.setAccountingGroup(protoUnit.getAccountingGroup());
                }
                newUnit.save();
                unit = newUnit;
                OrderMate.LOG.info("Unable to match paymentType, making it as WEB: " + paymentTypeName);
            } else if ("DELETED".equals(unit.getSystemState())) {
                OrderMate.LOG.info(paymentTypeName + " was deleted, setting to ACTIVE");
                unit.setSystemState("ACTIVE");
                unit.save();
            }
            return unit;
        }
        return null;
    }

    protected void save(boolean shouldPrint, Boolean isPaid) {
        this.save(shouldPrint, true, isPaid);
    }

    protected void save(boolean shouldPrint, boolean shouldPrintReceipt, Boolean isPaid) {
        if (!this.account.isLocked(this.integrationContext.getEventContext().getUser())) {
            this.account.lock(this.integrationContext.getEventContext().getUser());
        }
        SimpleSaveAccount saver = new SimpleSaveAccount(new DummyGUIHandler(), new SimplePrintAccount());
        saver.saveAccount(this.account, this.integrationContext.getEventContext());
        this.account = Account.reload(this.account);
        if (shouldPrint) {
            saver.printPrep(this.account, this.integrationContext.getEventContext());
            if (isPaid != null && isPaid.equals(Boolean.TRUE) && shouldPrintReceipt) {
                saver.printReceiptDockets(this.account, this.integrationContext.getEventContext());
            }
        }
        saver.autoAssignToDelivery(this.account);
        this.account.unlock();
    }

    protected boolean checkCommentContainsConfirmationStringSafe(String comment) {
        if (comment == null) {
            return false;
        }
        return comment.contains("(PLEASE CALL CUSTOMER TO CONFIRM THE ADDRESS)");
    }
}

