/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler;

import au.com.ordermate.util.StringUtils;
import ordermate.database.integration.online.EtaMode;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.integration.online.OnlineIntegrationETAHelper;
import ordermate.integration.onlinesales.posthandler.AbstractPostHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;

class DefaultOnlineOrderPostHandler
extends AbstractPostHandler {
    DefaultOnlineOrderPostHandler(SalesXMLIntegrationContext context) {
        super(context);
    }

    @Override
    protected void checkValid() throws Exception {
        if (this.account.getCustomer() == null && StringUtils.isEmpty(this.sale.getAccountType())) {
            throw new IllegalStateException("Cannot have an online order without a customer attached.");
        }
    }

    @Override
    protected void setEta() {
        OnlineIntegrationETA eta;
        OnlineIntegrationConfig.PrintingStrategy printing = OnlineIntegrationConfig.getConfigFor(this.sale.getExtSourceName()).getPrintingStrategy();
        if (Boolean.TRUE.equals(this.sale.isIsPaid()) && OnlineIntegrationConfig.PrintingStrategy.PAID.equals((Object)printing)) {
            OnlineIntegrationETA eta2 = OnlineIntegrationETA.getETAForAccountType(this.account.getAccountType());
            if (!EtaMode.ALWAYS_ASK.equals((Object)eta2.getETAMode())) {
                OnlineIntegrationETAHelper.setEtaForAccount(this.account, eta2);
            }
        } else if (OnlineIntegrationConfig.PrintingStrategy.ALWAYS.equals((Object)printing) && EtaMode.USE_CURRENT.equals((Object)(eta = OnlineIntegrationETA.getETAForAccountType(this.account.getAccountType())).getETAMode())) {
            OnlineIntegrationETAHelper.setEtaForAccount(this.account, eta);
        }
    }

    @Override
    protected void saveAccount() {
        OnlineIntegrationConfig.PrintingStrategy printing = OnlineIntegrationConfig.getConfigFor(this.sale.getExtSourceName()).getPrintingStrategy();
        boolean shouldPrint = false;
        Boolean hasPaid = this.sale.isIsPaid();
        if (Boolean.TRUE.equals(hasPaid)) {
            this.doPaid();
        }
        if (OnlineIntegrationConfig.PrintingStrategy.ALWAYS.equals((Object)printing) || Boolean.TRUE.equals(hasPaid) && OnlineIntegrationConfig.PrintingStrategy.PAID.equals((Object)printing) || OnlineIntegrationConfig.PrintingStrategy.ON_ETA_SET.equals((Object)printing) && this.account.getEta() != null) {
            shouldPrint = true;
        }
        this.save(shouldPrint, false, hasPaid);
    }
}

