/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler;

import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.integration.online.OnlineIntegrationETAHelper;
import ordermate.database.sales.AccountType;
import ordermate.integration.onlinesales.posthandler.AbstractPostHandler;
import ordermate.integration.onlinesales.posthandler.OnlineTableReservationAssociator;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;

class OnlinePreTablePostHandler
extends AbstractPostHandler {
    OnlinePreTablePostHandler(SalesXMLIntegrationContext context) {
        super(context);
    }

    @Override
    protected void checkValid() throws Exception {
        if (this.account.getCustomer() == null) {
            throw new IllegalStateException("Cannot have an online table account order without a customer attached.");
        }
    }

    @Override
    protected void setEta() {
        if (OnlineIntegrationConfig.PrintingStrategy.ALWAYS.equals((Object)OnlineIntegrationConfig.getConfigFor(this.sale.getExtSourceName()).getPrintingStrategy())) {
            OnlineIntegrationETA eta = OnlineIntegrationETA.getETAForAccountType(this.account.getAccountType());
            OnlineIntegrationETAHelper.setEtaForAccount(this.account, eta);
        }
    }

    @Override
    protected void saveAccount() {
        this.account.setAccountType(AccountType.onlineTableType);
        if (OnlineIntegrationConfig.PrintingStrategy.ALWAYS.equals((Object)OnlineIntegrationConfig.getConfigFor(this.sale.getExtSourceName()).getPrintingStrategy())) {
            this.save(true, false, false);
        } else {
            this.save(false, false);
        }
        OnlineTableReservationAssociator.examineAndAssociate(this.account);
    }
}

