/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler;

import java.math.BigDecimal;
import ordermate.database.Payable;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.integration.online.OnlineIntegrationETAHelper;
import ordermate.database.sales.AccountType;
import ordermate.integration.onlinesales.posthandler.AbstractPostHandler;
import ordermate.integration.onlinesales.posthandler.OnlineTableReservationAssociator;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;

class OnlineTablePostHandler
extends AbstractPostHandler {
    OnlineTablePostHandler(SalesXMLIntegrationContext context) {
        super(context);
    }

    @Override
    protected void checkValid() throws Exception {
        if (this.account.getCustomer() == null) {
            throw new IllegalStateException("Cannot have an online table account order without a customer attached.");
        }
    }

    @Override
    protected void setEta() {
        OnlineIntegrationETA eta = OnlineIntegrationETA.getETAForAccountType(this.account.getAccountType());
        OnlineIntegrationETAHelper.setEtaForAccount(this.account, eta);
    }

    @Override
    protected void saveAccount() {
        this.account.setAccountType(AccountType.onlineTableType);
        OnlineIntegrationConfig.PrintingStrategy printing = OnlineIntegrationConfig.getConfigFor(this.sale.getExtSourceName()).getPrintingStrategy();
        Boolean hasPaid = this.sale.isIsPaid();
        if (Boolean.TRUE.equals(hasPaid) && BigDecimal.ZERO.compareTo(this.sale.getTotalPrice()) != 0) {
            this.doPaid();
            this.account.lock(this.integrationContext.getEventContext().getUser());
        }
        boolean shouldPrint = false;
        if (Payable.PAID.equals(this.account.getPaidState()) && OnlineIntegrationConfig.PrintingStrategy.PAID.equals((Object)printing)) {
            if (!this.account.isLocked(this.integrationContext.getEventContext().getUser())) {
                this.account.lock(this.integrationContext.getEventContext().getUser());
            }
            shouldPrint = true;
        } else if (OnlineIntegrationConfig.PrintingStrategy.ALWAYS.equals((Object)printing)) {
            shouldPrint = true;
        } else if (OnlineIntegrationConfig.PrintingStrategy.ON_ETA_SET.equals((Object)printing)) {
            shouldPrint = this.account.getEta() != null;
        }
        this.save(shouldPrint, false, hasPaid);
        OnlineTableReservationAssociator.examineAndAssociate(this.account);
    }
}

