/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.integration.diamondback.DiamondBackIntegrator;

class OnlineTableReservationAssociator {
    final TableAccount theAccount;

    static void examineAndAssociate(Account theAccount) {
        boolean goodToTry;
        boolean bl = goodToTry = theAccount != null && theAccount instanceof TableAccount && ((TableAccount)theAccount).getTable() != null && ((TableAccount)theAccount).getTable().getTableGroup().isOnline() && ReservationIntegrationType.DIAMONDBACK.equals((Object)SystemProperty.getInstance().getReservationIntegration());
        if (goodToTry) {
            new OnlineTableReservationAssociator((TableAccount)theAccount).doAssociation();
        }
    }

    private OnlineTableReservationAssociator(TableAccount theAccount) {
        this.theAccount = theAccount;
    }

    void doAssociation() {
        LogicalTable table = this.theAccount.getTable();
        TableGroup group = table.getTableGroup();
        if (group.isOnline()) {
            try {
                Reservation reservation = this.tryToAssociate();
                if (reservation != null) {
                    DiamondBackIntegrator.getInstance().accountLinkedToReservation(this.theAccount, reservation);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot associate online table account to reservation", (Throwable)ex);
            }
        }
    }

    private Reservation tryToAssociate() {
        String name = this.theAccount.getTable().getPrimaryPhysicalTable().getName();
        List<TableAccount> potentialAccounts = PersistenceManager.getObjectList(TableAccount.class, Query.select(TableAccount.class).linkUsing(TableAccount.Properties.TABLE).linkUsing(LogicalTable.Properties.TABLE_GROUP).equals(TableAccount.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(TableGroup.Properties.ONLINE, "0").toString());
        for (TableAccount nextAccount : potentialAccounts) {
            for (PhysicalTable nextTable : nextAccount.getTable().getPhysicalTables()) {
                List<Reservation> reservations;
                if (!name.equals(nextTable.getName()) || (reservations = ReservationsHelper.getReservationsForTableAccount(nextAccount)).isEmpty()) continue;
                Reservation res = reservations.get(0);
                res.linkAccount(this.theAccount);
                res.save();
                OrderMate.LOG.info("Associating online account " + this.theAccount + " with reservation " + res.getID());
                return res;
            }
        }
        OrderMate.LOG.info("No association performed for " + this.theAccount);
        return null;
    }
}

