/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler;

import au.com.ordermate.util.Price;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.sales.Account;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.posthandler.AbstractPostHandler;
import ordermate.integration.onlinesales.posthandler.payment.OnlinePrePaymentFactory;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;

public class PaymentPostHandler
extends AbstractPostHandler {
    public PaymentPostHandler(SalesXMLIntegrationContext context) {
        super(context);
    }

    @Override
    protected void checkValid() throws Exception {
    }

    @Override
    protected void setEta() {
    }

    @Override
    protected void saveAccount() {
    }

    public void handlePayment(Account theAccount, OrderMateSale theSale) {
        this.account = theAccount;
        this.sale = theSale;
        if (theSale.getPayments().size() > 0) {
            Price paid = new Price(theSale.getPayments().get(0).getAmount(), 0.01);
            Price due = theAccount.getDue();
            if (due.lessThan(paid)) {
                throw new IllegalStateException("Cannot overpay an account with online payment " + paid + " but due is " + due);
            }
        }
        this.doPaid();
    }

    @Override
    protected void doPaid() {
        OnlinePrePaymentFactory factory = new OnlinePrePaymentFactory();
        factory.makePaymentMethod(OnlineIntegrationConfig.PrePaymentMethod.ADD_PAYMENT_TYPE, OnlineIntegrationConfig.getConfigFor(this.sale.getExtSourceName()), this.createEventContext()).handleAccountPayment(this.account, this.integrationContext.getEventContext().getUser());
    }
}

