/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler.payment;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.sales.Account;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.users.User;
import ordermate.integration.onlinesales.OnlineAccountEventContext;
import ordermate.integration.onlinesales.posthandler.payment.AbstractOnlineAccountPrePaymentMethod;

class OnlineAccountPrePaymentToDebtor
extends AbstractOnlineAccountPrePaymentMethod {
    private final OnlineIntegrationConfig config;

    public OnlineAccountPrePaymentToDebtor(OnlineAccountEventContext context, OnlineIntegrationConfig config) {
        super(context);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAccountPayment(Account account, User user) {
        AbstractDebtor debtor = null;
        debtor = account instanceof OnlineAccount ? this.getDebtorForOnlineAccount() : this.getDebtorForOnlineAccount();
        if (!account.isLocked(user) && !account.lock(user)) {
            OrderMate.LOG.warn("Cannot lock the account to pay it to the debtor. Will keep trying with a 1 second wait between attempts.");
            int count = 10;
            do {
                try {
                    Thread.sleep(1000L);
                    --count;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!account.isLocked(user) && !account.lock(user) && count >= 0);
            if (!account.isLocked(user)) {
                OrderMate.LOG.error("Cannot lock account to make debtor payment, cannot continue. Please settle manually.");
                return;
            }
        }
        debtor.lock(user);
        OrderMate.LOG.debug("Debtor " + debtor.getLabel() + " (" + debtor.getID() + ") locked to " + user.getLabel() + " (" + user.getID() + ")");
        try {
            account.closeUnchecked(this.context);
            if (account instanceof OnlineAccount && this.saleShouldBeAcknowledged(account)) {
                ((OnlineAccount)account).acknowledge();
            }
            account.save();
            try {
                CashDrawer toUse;
                if (!account.isLocked(user)) {
                    OrderMate.LOG.error("** Account was unlocked " + account.getID() + " while paying to a debtor!");
                    account.lock(user);
                }
                if ((toUse = this.config.getCashDrawer()) == null) {
                    toUse = CashDrawer.getOnlineCashDrawer(this.context.getTerminal(), this.context.getUser());
                }
                DebtorSale debtorSale = debtor.addSale(account, new FinanceTransactionContext(this.context, toUse), "");
                debtorSale.saveChild();
                debtor.save();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Error creating Debtor Sale for Online Order: " + account.getLabel(), (Throwable)e);
                account.setComment("Error creating Debit Sale for prepaid Online Order.\n\nPlease contact OrderMate Support.");
                account.save();
            }
        }
        finally {
            account.unlock();
            debtor.unlock();
        }
    }

    private AbstractDebtor getDebtorForOnlineAccount() {
        AbstractDebtor payDebtor = this.config.getPayOffDebtor();
        if (payDebtor != null && payDebtor.isActive()) {
            return payDebtor;
        }
        return this.getOrCreateDefaultDebtorForSource();
    }

    private AbstractDebtor getOrCreateDefaultDebtorForSource() {
        ObjectQuery select;
        AbstractDebtor defaultDebtor;
        String label = "Internet Prepayment";
        if (!OnlineIntegrationConfig.getDefaultInstance().equals(this.config)) {
            label = label + " " + this.config.getLabel();
        }
        if ((defaultDebtor = PersistenceManager.getObject(AbstractDebtor.class, (select = Query.select(AbstractDebtor.class).equals(AbstractDebtor.Properties.LABEL, label).orderBy(AbstractDebtor.Properties.SYSTEM_STATE).limit(1)).toString(), null)) == null) {
            defaultDebtor = new SimpleDebtor(label);
        } else {
            defaultDebtor.setSystemState("ACTIVE");
        }
        defaultDebtor.save();
        defaultDebtor = (AbstractDebtor)PersistenceManager.reacquire(defaultDebtor);
        return defaultDebtor;
    }
}

