/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler.payment;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.HashSet;
import ordermate.OrderMate;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.KickCashdrawer;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.database.users.User;
import ordermate.gui.SimpleSaveAccount;
import ordermate.integration.onlinesales.OnlineAccountEventContext;
import ordermate.integration.onlinesales.posthandler.payment.AbstractOnlineAccountPrePaymentMethod;
import ordermate.integration.onlinesales.posthandler.payment.OnlineAccountPrePayment;

class OnlineAccountPrePaymentToPayType
extends AbstractOnlineAccountPrePaymentMethod {
    private static final String ORDERMATE_ONLINE = "OrderMate Online";
    private static final String HUNGRY_HUNGRY = "HungryHungry";
    private static final String DOSHII = "Doshii";
    private final OnlineIntegrationConfig config;
    private boolean saveOnSet = true;

    OnlineAccountPrePaymentToPayType(OnlineAccountEventContext context, OnlineIntegrationConfig config) {
        super(context);
        this.config = config;
    }

    @Override
    public void handleAccountPayment(Account account, User user) {
        this.doPayments(account, user);
        if (this.saveOnSet) {
            account.lock(user);
            this.checkShouldCloseAndAcknowledgeAccount(account, Terminal.getLocalHost(), user);
            account.save();
            account.unlock();
        }
    }

    private void doPayments(Account account, User user) {
        HashSet<CashDrawer> drawers = new HashSet<CashDrawer>();
        Terminal term = Terminal.getLocalHost();
        term = (Terminal)PersistenceManager.reacquire(term);
        for (OnlineAccountPrePayment payment : this.context.getPrePayments()) {
            FinanceUnit unit = this.getFinanceUnitToUse(account, payment);
            CashDrawer drawer = this.getCashdrawerToUse(payment, term, user);
            if (KickCashdrawer.Always.equals((Object)unit.getKickCashdrawer())) {
                drawers.add(drawer);
            }
            this.makePayment(payment, term, user, unit, drawer, account, account.getSource());
        }
        for (CashDrawer nextDrawer : drawers) {
            if (nextDrawer == null || !nextDrawer.isUserPayable()) continue;
            try {
                nextDrawer.open(user);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Couldn't kick the cashdrawer:", (Throwable)ex);
            }
        }
    }

    private void makePayment(OnlineAccountPrePayment payment, Terminal term, User user, FinanceUnit unit, CashDrawer drawer, Account account, String source) {
        try {
            CashDrawer.checkTerminalCanUseCashDrawer(drawer, term, user);
            FinanceTransaction financeTransaction = this.getFinanceTransactionForPayment(payment.getAmount(), payment.getTip(), unit, term, drawer, user, account);
            if (financeTransaction == null) {
                throw new IllegalStateException("FinanceTransaction was not created.");
            }
            if (!StringUtils.isEmpty(payment.getSource())) {
                financeTransaction.setSource(payment.getSource());
            } else if (!StringUtils.isEmpty(source)) {
                financeTransaction.setSource(source);
            }
            if (!StringUtils.isEmpty(payment.getReference())) {
                financeTransaction.setTransactionReference(payment.getReference());
                for (FinanceTransaction txn : account.getFinanceTransactions()) {
                    if (!financeTransaction.getTransactionReference().equals(txn.getTransactionReference())) continue;
                    OrderMate.LOG.warn("Error creating Transaction for prepaid Online Order, already exists." + account.getLabel());
                    return;
                }
            }
            if (payment.getSurcharge() != null) {
                financeTransaction.setSurcharge(payment.getSurcharge());
            }
            account.addFinanceTransaction(financeTransaction);
            if (payment.getSurcharge() != null && "ACTIVE".equals(financeTransaction.getSystemState())) {
                FinanceSurchargeCalculator.applySurcharge(account, financeTransaction.getSubType(), financeTransaction.getSurcharge(), this.context);
            }
            OrderMate.LOG.info("Making payment for account :" + financeTransaction.getPaid());
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error creating Debit Transaction for prepaid Online Order: " + account.getLabel(), (Throwable)e);
            account.setComment("Error creating Debit Transaction for prepaid Online Order.\n\nPlease contact OrderMate Support.");
        }
    }

    private void checkShouldCloseAndAcknowledgeAccount(Account account, Terminal term, User user) {
        try {
            if (account instanceof OnlineAccount && this.saleShouldBeAcknowledged(account)) {
                ((OnlineAccount)account).acknowledge();
            }
            if (this.canAccountBeClosed(account)) {
                if (!(account instanceof BarTabAccount)) {
                    this.printReceipts(account);
                    account.close(this.context);
                    new SimpleSaveAccount(new DummyGUIHandler(), new SimplePrintAccount()).printPaidOffReceipts(account, this.context);
                }
                OrderMate.LOG.info("Payments made to account, fully paid. Will close");
            } else if (this.context.getVirtualPrinter() != null) {
                OrderMate.LOG.info("Payments made to an account, but not fully paid. Will not close!");
            } else {
                OrderMate.LOG.info("Payments made to an account, but the virtual printer is NOT set. Will not close!");
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while acknowledging and closing online account.", (Throwable)ex);
        }
    }

    private void printReceipts(Account account) {
        if (this.shouldReceiptsBePrinted(account)) {
            try {
                account.printReceiptDockets(this.context.getUser(), this.context.getTerminal());
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Could not print Receipt for online Order ", (Throwable)ex);
            }
        }
    }

    private boolean shouldReceiptsBePrinted(Account account) {
        boolean printerRequested = !StringUtils.isEmpty(this.context.getOrderMateSale().getReceiptPrinterName());
        boolean printerAvailable = this.context.getVirtualPrinter() != null;
        return printerRequested && printerAvailable;
    }

    private boolean canAccountBeClosed(Account account) {
        boolean printerAvailable;
        boolean accountPaid = Price.ZERO_DOLLAR.equals(account.getDue(0.01));
        boolean printerRequested = !StringUtils.isEmpty(this.context.getOrderMateSale().getReceiptPrinterName());
        boolean bl = printerAvailable = this.context.getVirtualPrinter() != null;
        if (accountPaid && printerRequested && printerAvailable) {
            OrderMate.LOG.info("Account can be closed since account is paid, printer is request and printer available");
            return true;
        }
        if (accountPaid && !printerRequested) {
            OrderMate.LOG.info("Account can be closed since account is paid, printer is not requested");
            return true;
        }
        OrderMate.LOG.info("Account cannot be closed since accountPaid " + accountPaid + " printerRequested " + printerRequested + " printerAvailable : " + printerAvailable);
        return false;
    }

    private FinanceUnit getFinanceUnitToUse(Account account, OnlineAccountPrePayment payment) {
        FinanceUnit unit = payment.getPaymentType();
        if (unit != null) {
            if ("CASH".equals(unit.getType()) || "CREDIT".equals(unit.getType()) || "DEBIT".equals(unit.getType()) || "WEB".equals(unit.getType())) {
                if (DOSHII.equals(account.getSource()) && !unit.isModifiable()) {
                    unit.setModifiable(true);
                    unit.save();
                }
                return unit;
            }
            OrderMate.LOG.info("OnlineAccountPrePaymentToPayType - Payment Type: " + unit + ", is not of allowed type CREDIT, DEBIT, WEB or CASH");
        }
        if ((unit = this.config.getPayOffFinanceUnit()) == null) {
            String unitName = account.getSource();
            if (!StringUtils.isEmpty(unitName)) {
                if (ORDERMATE_ONLINE.equals(unitName)) {
                    unitName = HUNGRY_HUNGRY;
                }
                if (!StringUtils.isEmpty(account.getExtOrigin())) {
                    unitName = unitName + " - " + account.getExtOrigin();
                }
                if ((unit = FinanceUnit.getUnitForNameIgnoreSystemState(unitName)) == null) {
                    unit = FinanceUnit.createUnit(FinanceUnit.WEB_TYPE, unitName, false);
                }
            } else {
                unit = FinanceUnit.getUnitForName("Internet Prepayment");
                if (unit == null && (unit = FinanceUnit.getDefaultUnitFor(FinanceUnit.WEB_TYPE)) == null) {
                    unit = FinanceUnit.getUnitForNameIgnoreSystemState("Internet Prepayment");
                    if (unit != null) {
                        unit.setSystemState("ACTIVE");
                        PersistenceManager.save(unit);
                    } else {
                        unit = new FinanceUnit("Internet Prepayment", FinanceUnit.WEB_TYPE, false);
                        PersistenceManager.save(unit);
                    }
                }
            }
        }
        if (unit != null) {
            if (DOSHII.equals(account.getSource()) && !unit.isModifiable()) {
                unit.setModifiable(true);
                unit.save();
            }
            if (!"ACTIVE".equals(unit.getSystemState())) {
                unit.setSystemState("ACTIVE");
                unit.save();
            }
        }
        return unit;
    }

    private CashDrawer getCashdrawerToUse(OnlineAccountPrePayment payment, Terminal terminal, User user) {
        if (payment.getCashdrawer() != null) {
            return payment.getCashdrawer();
        }
        if (this.config.getCashDrawer() != null) {
            return this.config.getCashDrawer();
        }
        return CashDrawer.getOnlineCashDrawer(terminal, user);
    }

    private FinanceTransaction getFinanceTransactionForPayment(Price amount, Price tip, FinanceUnit unit, Terminal term, CashDrawer drawer, User user, Account account) {
        if ("CASH".equals(unit.getType())) {
            return new CashTransaction(user, term, amount, amount, tip, drawer, term.getShift());
        }
        if ("CREDIT".equals(unit.getType())) {
            return new CreditTransaction(user, term, amount, tip, drawer, unit, term.getShift());
        }
        if ("WEB".equals(unit.getType())) {
            return new WebTransaction(user, term, amount, tip, drawer, unit, term.getShift());
        }
        return new DebitTransaction(user, term, amount, tip, Price.ZERO_DOLLAR, drawer, unit, term.getShift());
    }
}

