/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.posthandler.payment;

import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.OnlineAccountEventContext;
import ordermate.integration.onlinesales.posthandler.payment.AbstractOnlineAccountPrePaymentMethod;
import ordermate.integration.onlinesales.posthandler.payment.OnlineAccountPrePaymentToDebtor;
import ordermate.integration.onlinesales.posthandler.payment.OnlineAccountPrePaymentToPayType;

public class OnlinePrePaymentFactory {
    public AbstractOnlineAccountPrePaymentMethod makePaymentMethod(OrderMateSale sale, OnlineAccountEventContext context) {
        OnlineIntegrationConfig config = OnlineIntegrationConfig.getConfigFor(sale.getExtSourceName());
        return this.makePaymentMethod(config.getPrePaymentMethod(), config, context);
    }

    public AbstractOnlineAccountPrePaymentMethod makePaymentMethod(OnlineIntegrationConfig.PrePaymentMethod method, OnlineIntegrationConfig config, OnlineAccountEventContext context) {
        AbstractOnlineAccountPrePaymentMethod paymentMethod = null;
        switch (method) {
            case AUTO_PAY_TO_DEBTOR: {
                paymentMethod = new OnlineAccountPrePaymentToDebtor(context, config);
                break;
            }
            case ADD_PAYMENT_TYPE: {
                paymentMethod = new OnlineAccountPrePaymentToPayType(context, config);
                break;
            }
            default: {
                paymentMethod = new OnlineAccountPrePaymentToPayType(context, config);
            }
        }
        return paymentMethod;
    }
}

