/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.unknownitem;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventorySimpleCombo;
import ordermate.database.queries.inventory.InventoryAddQueries;
import ordermate.database.queries.inventory.InventoryComboQueries;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.queries.inventory.InventoryItemQueries;
import ordermate.database.queries.inventory.InventoryItemUnitQueries;
import ordermate.database.queries.inventory.InventoryOptionQueries;
import ordermate.database.queries.inventory.InventoryRemoveQueries;
import ordermate.database.queries.inventory.UnitPriceLevelQueries;
import ordermate.integration.onlinesales.unknownitem.UnknownItemHandler;

public class UnknownItemResolver
implements UnknownItemHandler {
    private final List<InventoryItemSize> allSizes = InventoryItemSize.getAllSizes();
    private final InventoryItemSize defaultSize = this.allSizes != null && !this.allSizes.isEmpty() ? this.allSizes.get(0) : null;
    private final List<InventoryGroup> allGroups = InventoryGroupQueries.getAllGroups();
    private final InventoryGroup defaultGroup = this.allGroups != null && !this.allGroups.isEmpty() ? this.allGroups.get(0) : null;

    @Override
    public InventoryItem handleUnknownItem() {
        InventoryItem unknownItem = InventoryItemQueries.getDeletedInventoryItemForName("!Unknown Online Item!");
        if (unknownItem == null) {
            unknownItem = new InventoryItem();
            unknownItem.setSystemState("DELETED");
            unknownItem.setCategory(InventoryCategory.getDefaultCategory());
            unknownItem.setLabel("!Unknown Online Item!");
            unknownItem.setShortName("!Unknown Online Item!");
            unknownItem.setIsOpenPrice(true);
            unknownItem.setMenuGroup(this.defaultGroup);
            PrinterGroup printerGp = PrinterGroup.getPrinterGroups() == null || PrinterGroup.getPrinterGroups().isEmpty() ? null : PrinterGroup.getPrinterGroups().get(0);
            unknownItem.setPrinterGroup(printerGp);
            unknownItem.save();
        }
        return unknownItem;
    }

    @Override
    public InventoryItemUnit handleUnknownItemUnit() {
        InventoryItemUnit unknownItemUnit = InventoryItemUnitQueries.getInventoryUnitForItem(this.handleUnknownItem(), SystemState.DELETED_STATE);
        if (unknownItemUnit == null) {
            unknownItemUnit = new InventoryItemUnit(this.defaultSize);
            unknownItemUnit.setSystemState("DELETED");
            unknownItemUnit.setItem(this.handleUnknownItem());
            List<TaxCode> defaultTaxCodes = PersistenceManager.getObjectList(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.DEFAULT_CODE, Boolean.TRUE).equals(TaxCode.Properties.ACCOUNTING, Boolean.FALSE).toString());
            unknownItemUnit.setTaxCodes(defaultTaxCodes);
            InventoryItemPortion wholePortion = InventoryItemPortion.findPortion("Whole");
            if (wholePortion != null) {
                unknownItemUnit.setPortion(wholePortion);
            }
            unknownItemUnit.saveChild();
        }
        return unknownItemUnit;
    }

    @Override
    public UnitPriceLevel handleUnknownUnitPriceLevel() {
        InventoryItemUnit unknownItemUnit = this.handleUnknownItemUnit();
        UnitPriceLevel unknownUnitPriceLevel = PersistenceManager.getObject(UnitPriceLevel.class, UnitPriceLevelQueries.getUnitPriceLevel(unknownItemUnit, PriceLevel.getDefaultPriceLevel()).toString());
        if (unknownUnitPriceLevel == null) {
            unknownUnitPriceLevel = new UnitPriceLevel(unknownItemUnit, PriceLevel.getDefaultPriceLevel());
            unknownUnitPriceLevel.setLoyaltyAdd(0);
            unknownUnitPriceLevel.setLoyaltyRedeem(99999);
            unknownUnitPriceLevel.setPrice(new Price("0"));
            unknownUnitPriceLevel.save();
        }
        return unknownUnitPriceLevel;
    }

    @Override
    public InventoryAddGroup handleUnknownAddGroup() {
        InventoryAddGroup unknownAddGroup = InventoryAddQueries.getInventoryAddGroupForNameAndSize("!Unknown Online Add Group!", this.defaultSize, SystemState.DELETED_STATE);
        if (unknownAddGroup == null) {
            unknownAddGroup = new InventoryAddGroup();
            unknownAddGroup.setSystemState("DELETED");
            unknownAddGroup.setLabel("!Unknown Online Add Group!");
            unknownAddGroup.setSize(this.defaultSize);
            unknownAddGroup.save();
        }
        return unknownAddGroup;
    }

    @Override
    public InventoryAdd handleUnknownAdd() {
        InventoryAdd unknownAdd = InventoryAddQueries.getInventoryAddForNameAndGroup("!Unknown Online Add!", this.handleUnknownAddGroup(), SystemState.DELETED_STATE);
        if (unknownAdd == null) {
            unknownAdd = new InventoryAdd();
            unknownAdd.setSystemState("DELETED");
            unknownAdd.setLabel("!Unknown Online Add!");
            unknownAdd.setAddGroup(this.handleUnknownAddGroup());
            unknownAdd.setPrice(new Price("0"));
            unknownAdd.saveChild();
        }
        return unknownAdd;
    }

    @Override
    public InventoryComboGroup handleUnknownComboGroup() {
        InventoryComboGroup unknownComboGroup = InventoryComboQueries.getInventoryComboGroupForName("!Unknown Online Combo Group!", SystemState.DELETED_STATE);
        if (unknownComboGroup == null) {
            unknownComboGroup = new InventoryComboGroup(this.handleUnknownCombo());
            unknownComboGroup.setSystemState("DELETED");
            unknownComboGroup.setName("!Unknown Online Combo Group!");
            unknownComboGroup.setApportionable(false);
            unknownComboGroup.setMinQuantity(new SalesQuantity("1"));
            unknownComboGroup.setMaxQuantity(new SalesQuantity("1"));
            unknownComboGroup.saveChild();
        }
        return unknownComboGroup;
    }

    @Override
    public InventoryCombo handleUnknownCombo() {
        InventoryCombo unknownCombo = InventoryComboQueries.getInventoryComboForNameAndGroup("!Unknown Online Combo!", this.defaultGroup, SystemState.DELETED_STATE);
        if (unknownCombo == null) {
            unknownCombo = new InventorySimpleCombo("!Unknown Online Combo!", "!Unknown Online Combo!", false);
            unknownCombo.setSystemState(SystemState.DELETED_STATE);
            unknownCombo.setMenuGroup(this.defaultGroup);
            unknownCombo.setProfile(InventoryProfileHelper.getInstance().getFirstProfile());
            unknownCombo.setUpgradeable(false);
            unknownCombo.save();
        }
        return unknownCombo;
    }

    @Override
    public InventoryOptionGroup handleUnknownOptionGroup() {
        InventoryOptionGroup unknownOptionGroup = InventoryOptionQueries.getInventoryOptionGroupForNameAndSize("!Unknown Online Option Group!", this.defaultSize, SystemState.DELETED_STATE);
        if (unknownOptionGroup == null) {
            unknownOptionGroup = new InventoryOptionGroup();
            unknownOptionGroup.setSystemState("DELETED");
            unknownOptionGroup.setLabel("!Unknown Online Option Group!");
            unknownOptionGroup.setSize(this.defaultSize);
            unknownOptionGroup.save();
        }
        return unknownOptionGroup;
    }

    @Override
    public InventoryOption handleUnknownOption() {
        InventoryOption unknownOption = InventoryOptionQueries.getInventoryOptionForNameAndGroup("!Unknown Online Option!", this.handleUnknownOptionGroup(), SystemState.DELETED_STATE);
        if (unknownOption == null) {
            unknownOption = new InventoryOption();
            unknownOption.setSystemState("DELETED");
            unknownOption.setLabel("!Unknown Online Option!");
            unknownOption.setOptionGroup(this.handleUnknownOptionGroup());
            unknownOption.setPrice(new Price("0"));
            unknownOption.saveChild();
        }
        return unknownOption;
    }

    @Override
    public InventoryRemove handleUnknownRemove() {
        InventoryRemove unknownRemove = InventoryRemoveQueries.getInventoryRemoveForNameAndItem("!Unknown Online Remove!", null, SystemState.DELETED_STATE);
        if (unknownRemove == null) {
            unknownRemove = new InventoryRemove();
            unknownRemove.setSystemState("DELETED");
            unknownRemove.setLabel("!Unknown Online Remove!");
            unknownRemove.setItem(this.handleUnknownItem());
            unknownRemove.setPrice(new Price("0"));
            unknownRemove.saveChild();
        }
        return unknownRemove;
    }
}

