/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.onlinesales.validator;

import au.com.ordermate.persistence.PersistentObject;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.DriveThruAccount;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.validator.OnlineSaleValidator;
import ordermate.jaxb.exporter.handlers.online.sales.AccountHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountHandlerException;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;
import org.apache.logging.log4j.Level;

class FullStackValidator
implements OnlineSaleValidator {
    private final AccountType accountType;

    public FullStackValidator(AccountType theAccountType) {
        this.accountType = theAccountType;
    }

    @Override
    public Account validate(OnlineOrderPrework prework, final SalesXMLIntegrationContext context) throws AccountHandlerException {
        AccountHandler handler = new AccountHandler(context){

            @Override
            protected Account createDomainInstance(OrderMateSale sale) {
                Account account = FullStackValidator.this.createAccount(context.getEventContext());
                account.lock(context.getEventContext().getUser());
                return account;
            }

            @Override
            public OnlineOrderPrework isImportReady(OrderMateSale entity, PersistentObject parent) {
                return new OnlineOrderPrework(entity, true);
            }
        };
        try {
            return handler.importElement(prework.sale, (PersistentObject)null);
        }
        catch (Exception e) {
            OrderMate.LOG.log(Level.WARN, "Bad Order:", (Throwable)e);
            throw new AccountHandlerException(new OnlineOrderPrework(prework.sale, prework.account, e.getMessage(), prework.readyToImport, prework.locked));
        }
    }

    protected Account createAccount(EventContext context) {
        Account account;
        if (this.accountType == null || AccountType.takeawayType.equals(this.accountType) || AccountType.quickSaleDineInType.equals(this.accountType)) {
            account = new TakeawayAccount();
        } else if (AccountType.tableType.equals(this.accountType)) {
            LogicalTable anyOldTable = new LogicalTable();
            account = new TableAccount(context.getUser(), anyOldTable, 1, context.getTerminal());
        } else if (AccountType.barTabType.equals(this.accountType)) {
            account = new BarTabAccount();
        } else if (AccountType.driveThruType.equals(this.accountType)) {
            account = new DriveThruAccount();
        } else if (AccountType.phoneType.equals(this.accountType)) {
            account = new PhoneAccount(context);
            ((PhoneAccount)account).setDeliverable(false, context);
        } else if (AccountType.deliveryType.equals(this.accountType)) {
            account = new PhoneAccount(context);
            ((PhoneAccount)account).setDeliverable(true, context);
        } else if (AccountType.onlinePickupType.equals(this.accountType)) {
            account = new OnlineAccount(context);
            ((OnlineAccount)account).setDeliverable(false, context);
        } else if (AccountType.onlineDeliveryType.equals(this.accountType)) {
            account = new OnlineAccount(context);
            ((OnlineAccount)account).setDeliverable(true, context);
        } else {
            account = new TakeawayAccount();
        }
        return account;
    }
}

