/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal;

import au.com.ordermate.configuration.Config;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.Boundary;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import ordermate.OrderMate;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.integration.jaxb.paypal.PayPalInvoice;
import ordermate.integration.jaxb.paypal.PayPalLocation;
import ordermate.integration.jaxb.paypal.PayPalPayment;
import ordermate.integration.jaxb.paypal.PayPalPaymentResponse;
import ordermate.integration.jaxb.paypal.PayPalRefundResponse;
import ordermate.integration.jaxb.paypal.PayPalStatus;
import ordermate.integration.jaxb.paypal.PayPalTab;
import ordermate.integration.paypal.PayPalIntegrationAuthorisation;
import ordermate.integration.paypal.PayPalOAuth;
import ordermate.integration.paypal.PayPalTool;
import ordermate.integration.webservice.RestHelper;
import org.apache.http.entity.ContentType;

public class PayPalComms {
    private static final String Scope = "https://uri.paypal.com/services/paypalhere";
    private static final String Status = "status/";
    private static final String Locations = "locations/";
    private static final String Logo = "logo";
    private static final String Tabs = "tabs/";
    private static final String Invoices = "invoices/";
    private static final String Pay = "pay/";
    private static final String Payments = "payments/";
    private static final String Sale = "sale/";
    private static final String Refund = "refund/";
    private final WebPaymentIntegration integration;
    private final PayPalOAuth auth;
    private final PayPalTool tool;

    public PayPalComms(WebPaymentIntegration integration) {
        this.integration = integration;
        this.tool = new PayPalTool();
        this.auth = new PayPalOAuth(integration);
    }

    public void doRequestToTakePayments() {
        PayPalIntegrationAuthorisation paymentAuth = new PayPalIntegrationAuthorisation(this.integration, Scope);
        paymentAuth.start();
    }

    public void doOAuthPairing() {
        if (this.integration.getAuthCode() != null) {
            if (!this.auth.hasValidToken()) {
                OrderMate.LOG.debug("Revalidating tokens");
                this.auth.getTokens();
            }
        } else {
            OrderMate.LOG.error("Cannot perform pairing if we don't have an authorisation code from the merchant");
        }
    }

    PayPalOAuth getAuth() {
        return this.auth;
    }

    public PayPalStatus checkStatus() {
        PayPalStatus status = null;
        String statusText = this.doCall("GET", this.prepend(Status), null);
        status = this.tool.getStatus(statusText);
        return status;
    }

    public List<PayPalLocation> getLocations() {
        List<PayPalLocation> locations = null;
        String response = this.doCall("GET", this.prepend(Locations), null);
        locations = this.tool.getLocations(response);
        return locations;
    }

    public String postLocation(PayPalLocation location) {
        String resource = this.prepend(Locations);
        if (location.getId() != null && !location.getId().isEmpty()) {
            resource = resource + "/" + location.getId();
        }
        String response = null;
        response = location.getId() == null || location.getId().trim().isEmpty() ? this.doCall("POST", resource, this.tool.marshal(location)) : this.doCall("PUT", resource, this.tool.marshal(location));
        return response;
    }

    public PayPalLocation deleteLocation(PayPalLocation location) {
        if (location == null || location.getId() == null || location.getId().isEmpty()) {
            OrderMate.LOG.warn("Cannot delete a null or null-id PayPalLocation");
            return null;
        }
        String response = this.doCall("DELETE", this.prepend("locations//" + location.getId()), null);
        PayPalLocation payPalLocation = this.tool.getLocation(response);
        return payPalLocation;
    }

    public Image getLogo(PayPalLocation location) {
        StringBuilder SB = new StringBuilder(this.prepend(Locations));
        if (location.getId() != null && !location.getId().isEmpty()) {
            SB.append(location.getId());
        }
        SB.append("/").append(Logo);
        String response = this.doCall("GET", SB.toString(), null);
        return null;
    }

    public String setLogo(PayPalLocation location, byte[] rawBytes) {
        StringBuilder SB = new StringBuilder(this.prepend(Locations));
        if (location.getId() != null && !location.getId().isEmpty()) {
            SB.append(location.getId());
        }
        SB.append("/").append(Logo);
        String response = this.doImageCall("POST", SB.toString(), rawBytes);
        return response;
    }

    public List<PayPalTab> getCurrentTabs(String locationId, AtomicReference<String> modifiedSince) {
        StringBuilder SB = new StringBuilder(this.prepend(Locations));
        SB.append(locationId).append("/").append(Tabs);
        SB.append("?" + Long.toString(System.currentTimeMillis()));
        Map<String, String> addHeaders = null;
        if (modifiedSince.get() != null) {
            // empty if block
        }
        Form returnedHeaders = new Form();
        if (Config.isDebuging()) {
            OrderMate.LOG.info("Request to get the Tabs:" + SB.toString());
        }
        String response = this.doCall("GET", SB.toString(), null, addHeaders, (MultivaluedMap)returnedHeaders);
        if (Config.isDebuging()) {
            OrderMate.LOG.info("Response from Tabs:" + response);
        }
        if (returnedHeaders.containsKey((Object)"Date")) {
            modifiedSince.set((String)((List)returnedHeaders.get((Object)"Date")).get(0));
            OrderMate.LOG.info("Modified since changed:" + modifiedSince.get());
        }
        List<PayPalTab> returnedTabs = this.tool.unmarshalList(response, PayPalTab.class);
        return returnedTabs;
    }

    public PayPalTab getTab(String locationId, String tabId) {
        StringBuilder SB = new StringBuilder(this.prepend(Locations));
        SB.append(locationId).append("/").append(Tabs).append(tabId);
        String response = this.doCall("GET", SB.toString(), null);
        return this.tool.unmarshal(response, PayPalTab.class);
    }

    public PayPalInvoice postInvoice(PayPalInvoice invoice) {
        StringBuilder SB = new StringBuilder(this.prepend(Invoices));
        if (invoice.getInvoiceID() != null && !invoice.getInvoiceID().isEmpty()) {
            SB.append("/").append(invoice.getInvoiceID());
        }
        String response = this.doCall("POST", SB.toString(), this.tool.marshal(invoice));
        PayPalInvoice theInvoice = this.tool.getInvoice(response);
        return theInvoice;
    }

    public PayPalInvoice getInvoice(String id) {
        StringBuilder SB = new StringBuilder(this.prepend(Invoices));
        SB.append("/").append(id);
        String response = this.doCall("GET", SB.toString(), null);
        PayPalInvoice invoice = this.tool.getInvoice(response);
        return invoice;
    }

    public PayPalInvoice deleteInvoice(PayPalInvoice invoice) {
        String response = this.doCall("DELETE", this.prepend(Invoices) + "/" + invoice.getInvoiceID(), null);
        return this.tool.getInvoice(response);
    }

    public PayPalPaymentResponse postPayment(PayPalPayment payment) {
        String response = this.doCall("POST", this.prepend(Pay), this.tool.marshal(payment));
        return this.tool.getPaymentResponse(response);
    }

    public PayPalRefundResponse postRefund(String saleId) {
        StringBuilder SB = new StringBuilder(this.prepend(Payments));
        SB.append(Sale).append(saleId).append("/").append(Refund);
        String response = this.doCall("POST", SB.toString(), null);
        PayPalRefundResponse refResponse = this.tool.getRefundResponse(response);
        return refResponse;
    }

    private String prepend(String toPrepend) {
        return this.integration.getWebserviceConfig().getUrl() + toPrepend;
    }

    private String doCall(String method, String url, String payload) {
        return this.doCall(method, url, payload, null, null);
    }

    private String doCall(String method, String url, String payload, Map<String, String> additionalHeaderFields, MultivaluedMap responseHeaderFields) {
        if (!this.auth.checkValidTokenAndResfreshIfRequired()) {
            OrderMate.LOG.warn("Cannot fire off a request if we have no token");
            return null;
        }
        String response = null;
        try {
            RestHelper rest = new RestHelper();
            OnlineIntegrationConfig config = OnlineIntegrationConfig.getDefaultInstance();
            WebResource resource = rest.getResource(url, config.getPaypalConnectionTimeout(), config.getPaypalReadTimeout());
            WebResource.Builder builder = resource.getRequestBuilder();
            if (additionalHeaderFields != null) {
                for (String headerField : additionalHeaderFields.keySet()) {
                    OrderMate.LOG.debug("Adding Header " + headerField);
                    builder = (WebResource.Builder)builder.header(headerField, (Object)additionalHeaderFields.get(headerField));
                }
            }
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)builder.header("Accept", (Object)ContentType.APPLICATION_JSON)).header("Authorization", (Object)("Bearer " + this.integration.getAccessToken()))).header("Content-Type", (Object)ContentType.APPLICATION_JSON)).type("application/json;charset=utf-8")).method(method, ClientResponse.class, (Object)payload);
            if (responseHeaderFields != null) {
                responseHeaderFields.putAll((Map)clientResponse.getHeaders());
            }
            if (clientResponse.getStatus() == 304) {
                return "";
            }
            response = (String)clientResponse.getEntity(String.class);
        }
        catch (UniformInterfaceException uni) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(uni.getResponse().getEntityInputStream()));
            StringBuilder out = new StringBuilder();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            OrderMate.LOG.error("Cannot query PayPal status", (Throwable)uni);
            this.logErrorObject(out.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot query PayPal status", (Throwable)ex);
        }
        if (response == null || response.contains("errorCode")) {
            this.logErrorObject(response);
        }
        return response;
    }

    private void logErrorObject(String response) {
        OrderMate.LOG.info("Error Object: \n" + response);
    }

    private String doImageCall(String method, String url, byte[] imagePayload) {
        if (!this.auth.checkValidTokenAndResfreshIfRequired()) {
            OrderMate.LOG.warn("Cannot fire off a request if we have no token");
            return null;
        }
        String response = null;
        try {
            ClientResponse clientResponse;
            RestHelper rest = new RestHelper();
            WebResource resource = rest.getResource(url);
            FormDataMultiPart form = null;
            if (imagePayload != null) {
                form = new FormDataMultiPart();
                FormDataBodyPart fdp = new FormDataBodyPart("file", (Object)new ByteArrayInputStream(imagePayload), new MediaType("image", "png"));
                FormDataContentDisposition fdcd = new FormDataContentDisposition("form-data; name=\"file\"; filename=\"logo.png\""){

                    protected StringBuilder toStringBuffer() {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.getType());
                        this.addStringParameter(sb, "name", this.getName());
                        this.addStringParameter(sb, "filename", this.getFileName());
                        this.addDateParameter(sb, "creation-date", this.getCreationDate());
                        this.addDateParameter(sb, "modification-date", this.getModificationDate());
                        this.addDateParameter(sb, "read-date", this.getReadDate());
                        this.addLongParameter(sb, "size", this.getSize());
                        return sb;
                    }
                };
                fdp.setFormDataContentDisposition(fdcd);
                form.bodyPart((BodyPart)fdp);
            }
            if (this.auth.hasValidToken() && (response = (String)(clientResponse = (ClientResponse)((WebResource.Builder)resource.header("Authorization", (Object)("Bearer " + this.integration.getAccessToken())).type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE))).method(method, ClientResponse.class, (Object)form)).getEntity(String.class)).isEmpty()) {
                response = clientResponse.toString();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot query PayPal status", (Throwable)ex);
        }
        return response;
    }

    public PayPalTool getPayPalTool() {
        return this.tool;
    }
}

