/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal;

import au.com.ordermate.util.IPAddressUtils;
import com.sun.jersey.api.client.WebResource;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import ordermate.OrderMate;
import ordermate.database.integration.WebResourceIntegration;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.integration.webservice.RestHelper;

class PayPalIntegrationAuthorisation {
    private final String orderMateAppId;
    private final WebPaymentIntegration integration;
    private final String scope;

    PayPalIntegrationAuthorisation(WebPaymentIntegration integration, String scope) {
        String AppID = "5ec13bbbeba369a3134b16e609ebde55";
        String AppSecret = "9603e340ba195c5f";
        this.integration = integration;
        this.orderMateAppId = integration.getAppId() == null ? "5ec13bbbeba369a3134b16e609ebde55" : integration.getAppId();
        this.scope = scope;
    }

    void start() {
        if (!WebResourceIntegration.getInstance().isEnabled()) {
            OrderMate.LOG.warn("Cannot have redirect if webservices are not enabled.");
            return;
        }
        String extIp = IPAddressUtils.getIPAddress();
        if (extIp == null) {
            OrderMate.LOG.warn("Cannot find external IP, cannot perform redirect");
            return;
        }
        this.integration.setAuthCode("1");
        this.integration.clearTokenData();
        this.integration.save();
        URI uri = this.getUri(extIp);
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot load up browser to accept PayPalPayments", (Throwable)ex);
        }
    }

    URI getUri(String externalIp) {
        RestHelper rest = new RestHelper();
        OnlineIntegrationConfig config = OnlineIntegrationConfig.getDefaultInstance();
        WebResource resource = rest.getResource(this.integration.getWebserviceConfig().getEndpointUrl() + "authorize", config.getPaypalConnectionTimeout(), config.getPaypalReadTimeout());
        resource = rest.addParameter(resource, "scope", this.scope);
        resource = rest.addParameter(resource, "response_type", "code");
        StringBuilder SB = new StringBuilder("http://localhost:8090/").append("integration/webpayment/authorise/");
        SB.append(this.integration.getID());
        resource = rest.addParameter(resource, "redirect_uri", SB.toString());
        resource = rest.addParameter(resource, "client_id", this.orderMateAppId);
        return resource.getURI();
    }
}

