/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal;

import au.com.ordermate.configuration.Config;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.util.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import ordermate.OrderMate;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.integration.webservice.RestHelper;

public class PayPalOAuth {
    static final int BUFFER_TIME = 300000;
    private static final String AppID = "5ec13bbbeba369a3134b16e609ebde55";
    private static final String AppSecret = "9603e340ba195c5f";
    private static final String URL = "https://www.paypal.com/webapps/hereapi/merchant/v1/locations";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String AUTH = "https://www.paypal.com/webapps/auth/protocol/openchannel/v1/authorize";
    private static final String SCOPE = "https://uri.paypal.com/services/paypalhere";
    private WebPaymentIntegration integration;
    private final RestHelper rest;

    public PayPalOAuth(WebPaymentIntegration integration) {
        this.integration = integration;
        this.rest = new RestHelper();
    }

    private String getClientIdAndSecret() {
        String clientId = AppID;
        String clientSecret = AppSecret;
        String toEncode = clientId + ":" + clientSecret;
        String output = "";
        try {
            output = new String(Base64.encode((byte[])toEncode.getBytes(Charset.forName("ASCII"))), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OrderMate.LOG.error("error encoding!", (Throwable)e);
        }
        return output;
    }

    public void getTokens() {
        if (this.integration.getAuthCode() == null || this.integration.getAuthCode().length() < 5) {
            throw new IllegalStateException("Cannot ask for tokens if the authorisation has not already been granted");
        }
        String url = "https://www.paypal.com/webapps/auth/protocol/openidconnect/v1/tokenservice";
        OnlineIntegrationConfig config = OnlineIntegrationConfig.getDefaultInstance();
        WebResource resource = this.rest.getResource(url, config.getPaypalConnectionTimeout(), config.getPaypalReadTimeout());
        Form input = new Form();
        input.add("grant_type", "authorization_code");
        input.add("code", this.integration.getAuthCode());
        input.add("scope", SCOPE);
        this.handleTokenRequest(resource, input);
    }

    public synchronized void refreshTokens() {
        if (this.integration.getAuthCode() == null || this.integration.getAuthCode().length() < 5) {
            throw new IllegalStateException("Cannot ask for tokens if the authorisation has not already been granted");
        }
        String url = "https://www.paypal.com/webapps/auth/protocol/openidconnect/v1/tokenservice";
        WebResource resource = this.rest.getResource(url);
        Form input = new Form();
        input.add("grant_type", "refresh_token");
        input.add("refresh_token", this.integration.getRefreshToken());
        input.add("scope", SCOPE);
        this.handleTokenRequest(resource, input);
    }

    private void handleTokenRequest(WebResource resource, Form input) {
        Calendar cal = Calendar.getInstance();
        try {
            Object expiry;
            WebResource.Builder builder = resource.header("Authorization", (Object)("Basic " + this.getClientIdAndSecret()));
            ClientResponse response = (ClientResponse)((WebResource.Builder)builder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).post(ClientResponse.class, (Object)input);
            ObjectMapper mapper = new ObjectMapper();
            Map output = (Map)mapper.readValue(response.getEntityInputStream(), Map.class);
            if (output.containsKey("error")) {
                OrderMate.LOG.error("Error: " + output.get("error") + "\nDesc: " + output.get("error_description"));
                throw new IllegalStateException("Error communicating with PayPal Webservice");
            }
            if (Config.isDebuging()) {
                StringBuilder SB = new StringBuilder("Got response for token:\r\n");
                for (Object key : output.keySet()) {
                    SB.append(key).append(":").append(output.get(key)).append("\r\n");
                }
                OrderMate.LOG.info(SB.toString());
            }
            this.integration.setAccessToken(String.valueOf(output.get(ACCESS_TOKEN)));
            if (output.get("refresh_token") != null) {
                this.integration.setRefreshToken(String.valueOf(output.get("refresh_token")));
            }
            if ((expiry = output.get("expires_in")) == null) {
                throw new IllegalStateException("Error communicating with PayPal Webservice - missing expires_in field in parameters returned");
            }
            int expiryInSeconds = Integer.parseInt(String.valueOf(expiry));
            cal.add(13, expiryInSeconds);
            this.integration.setExpiryDate(cal.getTime());
            this.integration.save();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot retrieve token from PayPal", (Throwable)ex);
        }
    }

    public synchronized boolean checkValidTokenAndResfreshIfRequired() {
        if (this.integration.getAccessToken() != null && this.integration.getExpiryDate() != null) {
            if (this.integration.getExpiryDate().getTime() <= System.currentTimeMillis() + 300000L) {
                OrderMate.LOG.info("Token Has Expired, refreshing");
                this.refreshTokens();
                return this.hasValidToken();
            }
            return true;
        }
        return false;
    }

    public boolean hasValidToken() {
        return this.integration.getAccessToken() != null && this.integration.getExpiryDate() != null && this.integration.getExpiryDate().getTime() > System.currentTimeMillis() - 300000L;
    }

    void setWebPaymentIntegration(WebPaymentIntegration webIntegration) {
        this.integration = webIntegration;
    }
}

