/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationType;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.jaxb.paypal.PayPalAddress;
import ordermate.integration.jaxb.paypal.PayPalError;
import ordermate.integration.jaxb.paypal.PayPalInvoice;
import ordermate.integration.jaxb.paypal.PayPalLocation;
import ordermate.integration.jaxb.paypal.PayPalPaymentResponse;
import ordermate.integration.jaxb.paypal.PayPalRefundResponse;
import ordermate.integration.jaxb.paypal.PayPalStatus;
import ordermate.integration.jaxb.paypal.PayPalTab;
import ordermate.integration.paypal.PayPalObjectMarshaller;
import ordermate.integration.paypal.invoice.PayPalInvoiceMaster;
import ordermate.integration.paypal.invoice.PayPalInvoiceStrategyNegativeItem;
import ordermate.misc.ObjectMarshaller;

public class PayPalTool {
    private static final String BaseURI = "https://www.paypal.com/webapps/hereapi/merchant/v1/";
    private static final String EndpointURI = "https://www.paypal.com/webapps/auth/protocol/openidconnect/v1/";
    private static final String SandboxURI = "https://api.sandbox.paypal.com/webapps/hereapi/merchant/v1/";
    private static final String SandboxEndpointURI = "https://api.sandbox.paypal.com/webapps/auth/protocol/openidconnect/v1/";
    private ObjectMarshaller marshaller = new PayPalObjectMarshaller();
    private static String ORDERMATE_ERROR_TYPE = "OrderMate Internal";

    public PayPalStatus getStatus(String status) {
        PayPalStatus ppStatus = this.unmarshal(status, PayPalStatus.class);
        return ppStatus;
    }

    public PayPalLocation getLocation(String json) {
        PayPalLocation location = this.unmarshal(json, PayPalLocation.class);
        return location;
    }

    public List<PayPalLocation> getLocations(String json) {
        List<PayPalLocation> locations = this.unmarshalList(json, PayPalLocation.class);
        return locations;
    }

    public PayPalTab getTab(String json) {
        PayPalTab tab = this.unmarshal(json, PayPalTab.class);
        return tab;
    }

    public PayPalInvoice getInvoice(String json) {
        PayPalInvoice invoice = this.unmarshal(json, PayPalInvoice.class);
        return invoice;
    }

    public PayPalRefundResponse getRefundResponse(String json) {
        PayPalRefundResponse response = this.unmarshal(json, PayPalRefundResponse.class);
        return response;
    }

    public PayPalPaymentResponse getPaymentResponse(String json) {
        PayPalPaymentResponse response = this.unmarshal(json, PayPalPaymentResponse.class);
        return response;
    }

    public Date convertToDate(String value) {
        String tempVal = value;
        if (value == null) {
            return null;
        }
        if (value.length() >= 2 && value.charAt(value.length() - 3) != ':') {
            tempVal = value.substring(0, value.length() - 2) + ":" + value.substring(value.length() - 2, value.length());
        }
        return ISO8601Utils.parse((String)tempVal);
    }

    public String convertToString(Date value) {
        if (value == null) {
            return null;
        }
        return ISO8601Utils.format((Date)value, (boolean)true, (TimeZone)TimeZone.getDefault());
    }

    public synchronized <T> T unmarshal(String value, Class<T> toCreate) {
        return this.marshaller.unmarshal(value, toCreate);
    }

    public synchronized <T> List<T> unmarshalList(String value, Class valueClass) {
        return this.marshaller.unmarshalList(value, valueClass);
    }

    public synchronized String marshal(Object toMarshal) {
        return this.marshaller.marshal(toMarshal);
    }

    public void applyItemsToInvoice(PayPalInvoice invoice, List<SalesLineItem> items, Price toPay, Price toTip) {
        Price totalPrice = Price.ZERO_DOLLAR;
        for (SalesLineItem item : items) {
            totalPrice = totalPrice.add(item.getPrice());
        }
        PayPalInvoiceMaster invoiceMaster = new PayPalInvoiceMaster(new PayPalInvoiceStrategyNegativeItem());
        invoiceMaster.populateInvoice(invoice, items, toPay, totalPrice);
        invoiceMaster.appendTip(invoice, toTip);
    }

    public void applyTabToCustomer(PayPalTab tab, WebPaymentCustomer customer) {
        customer.setCheckedIn("active".equals(tab.getStatus()));
        customer.setCreateDate(this.convertToDate(tab.getCreateDate()));
        customer.setUpdateDate(this.convertToDate(tab.getUpdateDate()));
        customer.setExpireDate(this.convertToDate(tab.getExpirationDate()));
        customer.setImageUrl(tab.getPhotoUrl());
        customer.setLabel(tab.getCustomerName());
    }

    public WebPaymentCustomer generateWebserviceIntegrationCustomer(PayPalTab tab, WebPaymentLocation location) {
        if (tab == null) {
            OrderMate.LOG.error("Cannot process null tab!");
            return null;
        }
        if (StringUtils.isEmpty(tab.getCustomerName()) || StringUtils.isEmpty(tab.getExpirationDate())) {
            OrderMate.LOG.error("Cannot process a customer without a label or expiration date. " + this.makeString(tab));
            return null;
        }
        WebPaymentCustomer customer = PersistenceManager.getObject(WebPaymentCustomer.class, Query.select(WebPaymentCustomer.class).equals(WebPaymentCustomer.Properties.EXT_ID, tab.getCustomerId()).equals(WebPaymentCustomer.Properties.LOCATION, location).toString());
        if (customer == null) {
            customer = new WebPaymentCustomer(location, tab.getCustomerName(), tab.getId(), tab.getCustomerId());
        }
        customer.setLabel(tab.getCustomerName());
        customer.setCreateDate(this.convertToDate(tab.getCreateDate()));
        customer.setExpireDate(this.convertToDate(tab.getExpirationDate()));
        customer.setCreateDate(this.convertToDate(tab.getCreateDate()));
        customer.setCheckedIn("active".equals(tab.getStatus()));
        customer.setImageUrl(tab.getPhotoUrl());
        return customer;
    }

    public void configureWebServiceDefaults(WebserviceIntegrationConfig config) {
        config.setWebserviceType(WebserviceIntegrationType.OAuth);
        config.setUrl(BaseURI);
        config.setEndpointUrl(EndpointURI);
    }

    public void configureWebServiceSandboxDefaults(WebserviceIntegrationConfig config) {
        config.setWebserviceType(WebserviceIntegrationType.OAuth);
        config.setUrl(SandboxURI);
        config.setEndpointUrl(SandboxEndpointURI);
    }

    public PayPalLocation makePayPalLocation(WebPaymentLocation location) {
        PayPalLocation pp = new PayPalLocation();
        pp.setId(location.getExtId());
        pp.setName(location.getLabel());
        pp.setInternalName(location.getInternalLabel());
        pp.setAddress(this.unmarshal(location.getAddress(), PayPalAddress.class));
        pp.setPhoneNumber(location.getPhone());
        pp.setDisplayMessage(location.getMessage());
        pp.setAvailability(location.isAvailable() ? "open" : "closed");
        pp.setCreateDate(this.convertToString(location.getCreatedDate()));
        pp.setUpdateDate(this.convertToString(location.getUpdatedDate()));
        pp.setLatitude(location.getLatitude());
        pp.setLongitude(location.getLongitude());
        pp.setMobility("fixed");
        pp.setTabDuration(BigInteger.valueOf(120L));
        if (WebPaymentLocation.ExtensionType.CheckIn.equals((Object)location.getExtensionType())) {
            pp.setTabExtensionUrl(null);
            pp.setTabExtensionType("none");
            pp.setTabExtensionButtonType(null);
        } else {
            String url = location.getExtensionUrl();
            if (!url.startsWith("https")) {
                url = "https://" + url;
            }
            if (!(url = url.trim()).endsWith("/")) {
                url = url + "/";
            }
            url = url + "{locationId}/{customerId}/{tabId}";
            pp.setTabExtensionUrl(url);
            pp.setTabExtensionButtonType("VIEWBILL");
            if (WebPaymentLocation.ExtensionType.CheckInAndPayAtTable.equals((Object)location.getExtensionType())) {
                pp.setTabExtensionType("status");
            } else {
                pp.setTabExtensionType("postOpen");
            }
        }
        pp.setTabType("standard");
        return pp;
    }

    public void applyToWebLocation(WebPaymentLocation location, PayPalLocation pp) {
        if (location.getExtId() != null && !location.getExtId().isEmpty() && !location.getExtId().equals(pp.getId())) {
            throw new IllegalArgumentException("Cannot apply a different paypal location to an existing web payment location");
        }
        location.setAvailable("open".equals(pp.getAvailability()));
        location.setCreatedDate(this.convertToDate(pp.getCreateDate()));
        location.setUpdatedDate(this.convertToDate(pp.getUpdateDate()));
        location.setExtId(pp.getId());
        location.setLabel(pp.getName());
        location.setInternalLabel(pp.getInternalName());
        location.setLatitude(pp.getLatitude());
        location.setLongitude(pp.getLongitude());
        location.setMessage(pp.getDisplayMessage());
        location.setPhone(pp.getPhoneNumber());
    }

    public PayPalError createPayPalError(String message, String developerMessage) {
        PayPalError error = new PayPalError();
        error.setErrorCode("");
        error.setErrorType(ORDERMATE_ERROR_TYPE);
        error.setDeveloperMessage(developerMessage);
        error.setMessage(message);
        error.setCorrelationId("");
        return error;
    }

    public PayPalError getSucesssfulPayPalError() {
        return this.createPayPalError("Success", "Success");
    }

    public String makeString(PayPalTab tab) {
        StringBuilder SB = new StringBuilder("PayPalTab:\r\n");
        SB.append("CreateDate:").append(tab.getCreateDate()).append(",ExtID:").append(tab.getCustomerId()).append(",Name:").append(tab.getCustomerName()).append(",Expires:").append(tab.getExpirationDate()).append(",Id:").append(tab.getId()).append(",Photo:").append(tab.getPhotoUrl()).append(",Status:").append(tab.getStatus()).append(",Update:").append(tab.getUpdateDate());
        return SB.toString();
    }
}

