/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal.invoice;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.database.integration.webpayment.WebPaymentType;
import ordermate.integration.jaxb.paypal.PayPalAddress;
import ordermate.integration.jaxb.paypal.PayPalInvoice;
import ordermate.integration.jaxb.paypal.PayPalMerchantInfo;
import ordermate.integration.paypal.PayPalTool;

public class PayPalInvoiceHelper {
    public static PayPalInvoice createInvoice() {
        WebPaymentIntegration integration = PersistenceManager.getObject(WebPaymentIntegration.class, Query.select(WebPaymentIntegration.class).active(WebPaymentIntegration.class).equals(WebPaymentIntegration.Properties.TYPE, (Object)WebPaymentType.PayPal).toString());
        if (integration == null) {
            throw new IllegalArgumentException("No Web Payment Integration is set up.");
        }
        List<WebPaymentLocation> locations = integration.getLocations();
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("No Web Payment Location is assigned to this Web Payment Integration.");
        }
        return PayPalInvoiceHelper.createInvoice(integration, locations.get(0));
    }

    public static PayPalInvoice createInvoice(WebPaymentIntegration integration, WebPaymentLocation loc) {
        PayPalInvoice invoice = new PayPalInvoice();
        invoice.setMerchantEmail(integration.getMerchantEmail());
        PayPalMerchantInfo ppmi = new PayPalMerchantInfo();
        ppmi.setBusinessName(loc.getLabel());
        ppmi.setPhoneNumber(loc.getPhone());
        ppmi.setAddress(new PayPalTool().unmarshal(loc.getAddress(), PayPalAddress.class));
        invoice.setMerchantInfo(ppmi);
        invoice.setCurrencyCode(Currency.getInstance(Locale.getDefault()).getCurrencyCode());
        invoice.setPaymentTerms("DueOnReceipt");
        StringBuilder SB = new StringBuilder("Making Invoice:\r\n");
        SB.append("Currency Code:").append(invoice.getCurrencyCode());
        SB.append("\r\nEmail:").append(invoice.getMerchantEmail());
        SB.append("\r\nLocale:").append(Locale.getDefault());
        OrderMate.LOG.info(SB.toString());
        return invoice;
    }
}

