/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal.invoice;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.jaxb.paypal.PayPalInvoice;
import ordermate.integration.jaxb.paypal.PayPalItem;
import ordermate.integration.paypal.invoice.PayPalInvoiceStrategy;

public class PayPalInvoiceStrategyFactorPrices
implements PayPalInvoiceStrategy {
    @Override
    public void appendPayPalInvoiceItems(PayPalInvoice invoice, List<SalesLineItem> items, Price toPay, Price itemTotalPrice) {
        boolean isPartPayment = !toPay.equals(itemTotalPrice);
        double multiplier = toPay.doubleValue() / itemTotalPrice.doubleValue();
        Price runningPaidTotal = Price.ZERO_DOLLAR;
        for (SalesLineItem salesLineItem : items) {
            SalesQuantity qty = salesLineItem.getQuantity();
            PayPalItem ppItem = new PayPalItem();
            ppItem.setName(salesLineItem.getLabel());
            ppItem.setQuantity(qty.getValue());
            if (isPartPayment) {
                ppItem.setDescription("Part Payment out of " + salesLineItem.getPrice());
                Price payoff = salesLineItem.getPrice().multiply(multiplier);
                ppItem.setUnitPrice(payoff.toBigDecimal());
                runningPaidTotal = runningPaidTotal.add(payoff);
            } else {
                ppItem.setUnitPrice(salesLineItem.getPricePerItem().toBigDecimal());
            }
            invoice.getItems().add(ppItem);
        }
        Price difference = itemTotalPrice.subtract(runningPaidTotal);
        if (!difference.equals(Price.ZERO_DOLLAR)) {
            PayPalItem payPalItem = invoice.getItems().get(0);
            payPalItem.setUnitPrice(payPalItem.getUnitPrice().add(difference.toBigDecimal()));
        }
    }
}

