/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal.invoice;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.List;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.jaxb.paypal.PayPalInvoice;
import ordermate.integration.jaxb.paypal.PayPalItem;
import ordermate.integration.paypal.invoice.PayPalInvoiceStrategy;

public class PayPalInvoiceStrategyNegativeItem
implements PayPalInvoiceStrategy {
    public static final String TENDERED_BY_OTHER_MEANS = "TENDERED BY OTHER MEANS";

    @Override
    public void appendPayPalInvoiceItems(PayPalInvoice invoice, List<SalesLineItem> items, Price toPay, Price itemTotalPrice) {
        for (SalesLineItem item : items) {
            SalesQuantity qty = item.getQuantity();
            PayPalItem ppItem = new PayPalItem();
            ppItem.setName(item.getLabel());
            ppItem.setQuantity(qty.getValue());
            ppItem.setUnitPrice(item.getPricePerItem().toBigDecimal());
            invoice.getItems().add(ppItem);
        }
        if (!toPay.equals(itemTotalPrice)) {
            Price tenderedDifference = toPay.subtract(itemTotalPrice);
            PayPalItem ppItem = new PayPalItem();
            ppItem.setName(TENDERED_BY_OTHER_MEANS);
            ppItem.setQuantity(new BigDecimal(1));
            ppItem.setUnitPrice(tenderedDifference.toBigDecimal());
            invoice.getItems().add(ppItem);
        }
    }
}

