/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal.remote;

import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.integration.jaxb.paypal.PayPalError;
import ordermate.integration.paypal.remote.PayPalServiceRemote;

public class PayPalServiceRemoteClient
implements PayPalServiceRemote {
    private static PayPalServiceRemoteClient instance;
    private PayPalServiceRemote remote;

    private PayPalServiceRemoteClient() {
    }

    public static PayPalServiceRemoteClient getInstance() {
        if (instance == null || instance.getRemoteAdministrator() == null) {
            instance = new PayPalServiceRemoteClient();
        }
        return instance;
    }

    public synchronized void setRemote(PayPalServiceRemote admin) {
        this.remote = admin;
    }

    public synchronized PayPalServiceRemote getRemoteAdministrator() {
        this.resolve();
        return this.remote;
    }

    protected synchronized boolean resolve() {
        if (this.remote == null) {
            try {
                this.remote = (PayPalServiceRemote)SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "PayPalServiceRemote", 11100);
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Cannot retrieve PayPalService from ServerMate", (Throwable)e);
            }
            catch (NotBoundException e) {
                OrderMate.LOG.error("Cannot retrieve PayPalService from ServerMate, Not shared?", (Throwable)e);
            }
        }
        return this.remote != null;
    }

    @Override
    public PayPalError changeLocationAvailability(WebPaymentLocation location, boolean open) {
        if (this.resolve()) {
            try {
                PayPalError result = this.getRemoteAdministrator().changeLocationAvailability(location, open);
                if (result == null) {
                    OrderMate.LOG.error("Cannot changeLocationAvailability, Error on server side");
                }
                return result;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot changeLocationAvailability, PayPalServiceRemoteClient might be down", (Throwable)ex);
                this.setRemote(null);
            }
        }
        return null;
    }

    @Override
    public void refresh() {
        if (this.resolve()) {
            try {
                this.getRemoteAdministrator().refresh();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot refresh, PayPalServiceRemoteClient might be down", (Throwable)ex);
                this.setRemote(null);
            }
        }
    }

    @Override
    public List<Long> getCachedWebPaymentCustomerIds() {
        if (this.resolve()) {
            try {
                List<Long> ids = this.getRemoteAdministrator().getCachedWebPaymentCustomerIds();
                if (ids == null) {
                    OrderMate.LOG.error("Cannot getCachedWebPaymentCustomerIds, Error on server side");
                }
                return ids;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot getCachedWebPaymentCustomerIds, PayPalServiceRemoteClient might be down", (Throwable)ex);
                this.setRemote(null);
            }
        }
        return null;
    }

    @Override
    public PayPalError trySyncLocation(WebPaymentLocation toSyne) {
        if (this.resolve()) {
            try {
                PayPalError error = this.getRemoteAdministrator().trySyncLocation(toSyne);
                if (error == null) {
                    OrderMate.LOG.error("Cannot trySyncLocation, Error on server side");
                }
                return error;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot trySyncLocation, PayPalServiceRemoteClient might be down", (Throwable)ex);
                this.setRemote(null);
            }
        }
        return null;
    }

    @Override
    public boolean tryDeleteLocation(WebPaymentLocation toDelete) {
        try {
            boolean result = this.getRemoteAdministrator().tryDeleteLocation(toDelete);
            if (!result) {
                OrderMate.LOG.error("Cannot tryDeleteLocation, Error on server side");
            }
            return result;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot tryDeleteLocation, PayPalServiceRemoteClient might be down", (Throwable)ex);
            this.setRemote(null);
            return false;
        }
    }

    @Override
    public boolean syncLogo(WebPaymentLocation location, byte[] imageRawBytes) {
        if (this.resolve()) {
            try {
                boolean result = this.getRemoteAdministrator().syncLogo(location, imageRawBytes);
                if (!result) {
                    OrderMate.LOG.error("Cannot syncLogo, Error on server side");
                }
                return result;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot syncLogo, PayPalServiceRemoteClient might be down", (Throwable)ex);
                this.setRemote(null);
            }
        }
        return false;
    }

    @Override
    public boolean tryDeleteAllLocations() {
        if (this.resolve()) {
            try {
                boolean result = this.getRemoteAdministrator().tryDeleteAllLocations();
                if (!result) {
                    OrderMate.LOG.error("Cannot deleteAllLocations, Error on server side");
                }
                return result;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot deleteAllLocations, PayPalServiceRemoteClient might be down", (Throwable)ex);
                this.setRemote(null);
            }
        }
        return false;
    }

    @Override
    public boolean updateIntegration() {
        if (this.resolve()) {
            try {
                boolean result = this.getRemoteAdministrator().updateIntegration();
                if (!result) {
                    OrderMate.LOG.error("Cannot updateIntegration, Error on server side");
                }
                return result;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot updateIntegration, PayPalServiceRemoteClient might be down", (Throwable)ex);
                this.setRemote(null);
            }
        }
        return false;
    }
}

