/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.paypal.remote;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.integration.jaxb.paypal.PayPalError;
import ordermate.integration.paypal.remote.PayPalServiceRemote;

public class PayPalServiceRemoteDelegate
extends UnicastRemoteObject
implements PayPalServiceRemote {
    private final PayPalServiceRemote delegate;

    public PayPalServiceRemoteDelegate(PayPalServiceRemote toDelegateTo) throws RemoteException {
        this.delegate = toDelegateTo;
    }

    @Override
    public PayPalError changeLocationAvailability(WebPaymentLocation location, boolean open) throws RemoteException {
        try {
            return this.delegate.changeLocationAvailability(location, open);
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Couldn't change location availability for location " + location, t);
            return null;
        }
    }

    @Override
    public void refresh() throws RemoteException {
        try {
            this.delegate.refresh();
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Error occured calling refresh!", t);
        }
    }

    @Override
    public List<Long> getCachedWebPaymentCustomerIds() throws RemoteException {
        try {
            return this.delegate.getCachedWebPaymentCustomerIds();
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Couldn't retrieve Web Payment Customer Id's", t);
            return this.delegate.getCachedWebPaymentCustomerIds();
        }
    }

    @Override
    public PayPalError trySyncLocation(WebPaymentLocation toSync) throws RemoteException {
        try {
            return this.delegate.trySyncLocation(toSync);
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Couldn't Sync Location " + toSync, t);
            return null;
        }
    }

    @Override
    public boolean syncLogo(WebPaymentLocation location, byte[] imageRawBytes) throws RemoteException {
        try {
            return this.delegate.syncLogo(location, imageRawBytes);
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Couldn't syncLogo to location " + location, t);
            return false;
        }
    }

    @Override
    public boolean tryDeleteLocation(WebPaymentLocation toDelete) {
        try {
            return this.delegate.tryDeleteLocation(toDelete);
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Couldn't delete location " + toDelete, t);
            return false;
        }
    }

    @Override
    public boolean tryDeleteAllLocations() throws RemoteException {
        try {
            return this.delegate.tryDeleteAllLocations();
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Couldn't delete all locations", t);
            return false;
        }
    }

    @Override
    public boolean updateIntegration() throws RemoteException {
        try {
            return this.delegate.updateIntegration();
        }
        catch (Throwable t) {
            OrderMate.LOG.error("Couldn't update integration", t);
            return false;
        }
    }
}

